/*
 * Decompiled with CFR 0.152.
 */
package gg.nils.semanticrelease.api.versioncontrol.git;

import gg.nils.semanticrelease.api.Branch;
import gg.nils.semanticrelease.api.BranchImpl;
import gg.nils.semanticrelease.api.RawCommit;
import gg.nils.semanticrelease.api.Tag;
import gg.nils.semanticrelease.api.Version;
import gg.nils.semanticrelease.api.config.SemanticReleaseConfig;
import gg.nils.semanticrelease.api.error.SemanticReleaseException;
import gg.nils.semanticrelease.api.versioncontrol.VersionControlProviderImpl;
import gg.nils.semanticrelease.api.versioncontrol.git.converter.DefaultGitRefToTagConverter;
import gg.nils.semanticrelease.api.versioncontrol.git.converter.DefaultGitRefsToTagsConverter;
import gg.nils.semanticrelease.api.versioncontrol.git.converter.DefaultGitRevCommitToRawCommitConverter;
import gg.nils.semanticrelease.api.versioncontrol.git.converter.DefaultGitRevCommitsToRawCommitsConverter;
import gg.nils.semanticrelease.api.versioncontrol.git.converter.GitRefToTagConverter;
import gg.nils.semanticrelease.api.versioncontrol.git.converter.GitRefsToTagsConverter;
import gg.nils.semanticrelease.api.versioncontrol.git.converter.GitRevCommitToRawCommitConverter;
import gg.nils.semanticrelease.api.versioncontrol.git.converter.GitRevCommitsToRawCommitsConverter;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;

public class GitVersionControlProvider
extends VersionControlProviderImpl {
    private final Git git;
    private GitRevCommitToRawCommitConverter gitRevCommitToRawCommitConverter;
    private GitRevCommitsToRawCommitsConverter gitRevCommitsToRawCommitsConverter;
    private GitRefToTagConverter gitRefToTagConverter;
    private GitRefsToTagsConverter gitRefsToTagsConverter;

    public GitVersionControlProvider(SemanticReleaseConfig config, Git git) {
        super(config);
        this.git = git;
        this.gitRevCommitToRawCommitConverter = new DefaultGitRevCommitToRawCommitConverter();
        this.gitRevCommitsToRawCommitsConverter = new DefaultGitRevCommitsToRawCommitsConverter(this.gitRevCommitToRawCommitConverter);
        this.gitRefToTagConverter = new DefaultGitRefToTagConverter();
        this.gitRefsToTagsConverter = new DefaultGitRefsToTagsConverter(this.gitRefToTagConverter);
    }

    @Override
    public List<RawCommit> getRawCommits() {
        try {
            Iterable revCommits = this.git.log().call();
            return (List)this.gitRevCommitsToRawCommitsConverter.convert(revCommits);
        }
        catch (GitAPIException e) {
            throw new SemanticReleaseException("Could not get commits", e);
        }
    }

    @Override
    public List<RawCommit> getRawCommitsSince(Version version) {
        if (version.getTag() == null) {
            return this.getRawCommits();
        }
        try {
            ObjectId since = ObjectId.fromString((String)version.getTag().getCommitId());
            ObjectId until = this.git.getRepository().resolve("HEAD");
            Iterable revCommits = this.git.log().addRange((AnyObjectId)since, (AnyObjectId)until).call();
            return (List)this.gitRevCommitsToRawCommitsConverter.convert(revCommits);
        }
        catch (IOException | GitAPIException e) {
            throw new SemanticReleaseException("Could not get commits since " + version, e);
        }
    }

    @Override
    public List<Tag> getTags() {
        try {
            List refs = this.git.tagList().call();
            return (List)this.gitRefsToTagsConverter.convert(refs);
        }
        catch (GitAPIException e) {
            throw new SemanticReleaseException("Could not get tags", e);
        }
    }

    @Override
    public Branch getCurrentBranch() {
        try {
            String branch = this.git.getRepository().getBranch();
            return new BranchImpl(branch);
        }
        catch (IOException e) {
            throw new SemanticReleaseException("Could not get current branch", e);
        }
    }

    @Override
    public boolean hasUncommittedChanges() {
        try {
            Status call = this.git.status().call();
            return call.hasUncommittedChanges();
        }
        catch (GitAPIException e) {
            throw new SemanticReleaseException("Could not get status", e);
        }
    }

    public void setGitRevCommitToRawCommitConverter(GitRevCommitToRawCommitConverter gitRevCommitToRawCommitConverter) {
        this.gitRevCommitToRawCommitConverter = gitRevCommitToRawCommitConverter;
    }

    public void setGitRevCommitsToRawCommitsConverter(GitRevCommitsToRawCommitsConverter gitRevCommitsToRawCommitsConverter) {
        this.gitRevCommitsToRawCommitsConverter = gitRevCommitsToRawCommitsConverter;
    }

    public void setGitRefToTagConverter(GitRefToTagConverter gitRefToTagConverter) {
        this.gitRefToTagConverter = gitRefToTagConverter;
    }

    public void setGitRefsToTagsConverter(GitRefsToTagsConverter gitRefsToTagsConverter) {
        this.gitRefsToTagsConverter = gitRefsToTagsConverter;
    }
}

