/*
 * Decompiled with CFR 0.152.
 */
package gg.nils.semanticrelease.api.versioncontrol;

import gg.nils.semanticrelease.api.Branch;
import gg.nils.semanticrelease.api.Commit;
import gg.nils.semanticrelease.api.Tag;
import gg.nils.semanticrelease.api.Version;
import gg.nils.semanticrelease.api.calculator.DefaultNextVersionCalculator;
import gg.nils.semanticrelease.api.calculator.NextVersionCalculator;
import gg.nils.semanticrelease.api.config.SemanticReleaseConfig;
import gg.nils.semanticrelease.api.versioncontrol.VersionControlProvider;
import gg.nils.semanticrelease.api.versioncontrol.converter.DefaultRawCommitToCommitConverter;
import gg.nils.semanticrelease.api.versioncontrol.converter.DefaultRawCommitsToCommitsConverter;
import gg.nils.semanticrelease.api.versioncontrol.converter.DefaultTagToVersionConverter;
import gg.nils.semanticrelease.api.versioncontrol.converter.RawCommitToCommitConverter;
import gg.nils.semanticrelease.api.versioncontrol.converter.RawCommitsToCommitsConverter;
import gg.nils.semanticrelease.api.versioncontrol.converter.TagToVersionConverter;
import java.util.List;

public abstract class VersionControlProviderImpl
implements VersionControlProvider {
    private final SemanticReleaseConfig config;
    private TagToVersionConverter tagToVersionConverter;
    private RawCommitToCommitConverter rawCommitToCommitConverter;
    private RawCommitsToCommitsConverter rawCommitsToCommitsConverter;
    private NextVersionCalculator nextVersionCalculator;

    protected VersionControlProviderImpl(SemanticReleaseConfig config) {
        this.config = config;
        this.tagToVersionConverter = new DefaultTagToVersionConverter();
        this.rawCommitToCommitConverter = new DefaultRawCommitToCommitConverter();
        this.rawCommitsToCommitsConverter = new DefaultRawCommitsToCommitsConverter(this.rawCommitToCommitConverter);
        this.nextVersionCalculator = new DefaultNextVersionCalculator(config);
    }

    @Override
    public List<Commit> getCommitsSince(Version version) {
        return (List)this.rawCommitsToCommitsConverter.convert(this.getRawCommitsSince(version));
    }

    @Override
    public Tag getLatestTag() {
        List<Tag> tags = this.getTags();
        if (tags == null || tags.isEmpty()) {
            return null;
        }
        return tags.get(tags.size() - 1);
    }

    @Override
    public Version getLatestVersion() {
        Tag latestTag = this.getLatestTag();
        if (latestTag == null) {
            return this.config.getFirstVersion();
        }
        return (Version)this.tagToVersionConverter.convert(latestTag);
    }

    @Override
    public Version getNextVersion() {
        Tag latestTag = this.getLatestTag();
        if (latestTag == null) {
            return this.config.getFirstVersion();
        }
        Version latestVersion = this.getLatestVersion();
        List<Commit> commits = this.getCommitsSince(latestVersion);
        return this.nextVersionCalculator.calculate(latestVersion, commits);
    }

    @Override
    public String getFullVersion() {
        Version nextVersion = this.getNextVersion();
        Branch currentBranch = this.getCurrentBranch();
        String version = "";
        String currentBranchName = currentBranch.getName();
        version = currentBranchName.equals("master") || currentBranchName.equals("main") ? version + nextVersion.toString() : (currentBranchName.equals("develop") ? version + nextVersion.toString() + "-SNAPSHOT" : version + nextVersion.toString() + "-" + currentBranchName.replaceAll("/", "-"));
        if (this.hasUncommittedChanges()) {
            version = version + "-DIRTY";
        }
        return version;
    }

    public void setTagToVersionConverter(TagToVersionConverter tagToVersionConverter) {
        this.tagToVersionConverter = tagToVersionConverter;
    }

    public void setRawCommitToCommitConverter(RawCommitToCommitConverter rawCommitToCommitConverter) {
        this.rawCommitToCommitConverter = rawCommitToCommitConverter;
    }

    public void setRawCommitsToCommitsConverter(RawCommitsToCommitsConverter rawCommitsToCommitsConverter) {
        this.rawCommitsToCommitsConverter = rawCommitsToCommitsConverter;
    }

    public void setNextVersionCalculator(NextVersionCalculator nextVersionCalculator) {
        this.nextVersionCalculator = nextVersionCalculator;
    }
}

