/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.context;

import javax.transaction.Synchronization;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.transaction.context.AbstractTransactionContext;

class UnspecifiedTransactionContext
extends AbstractTransactionContext {
    private boolean active = true;
    private boolean failed = false;

    public boolean isInheritable() {
        return false;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean enlistResource(XAResource xaResource) {
        throw new IllegalStateException("There is no transaction in progress.");
    }

    public boolean delistResource(XAResource xaResource, int flag) {
        throw new IllegalStateException("There is no transaction in progress.");
    }

    public void registerSynchronization(Synchronization synchronization) {
        throw new IllegalStateException("There is no transaction in progress.");
    }

    public boolean getRollbackOnly() {
        return this.failed;
    }

    public void setRollbackOnly() {
        this.failed = true;
    }

    public void suspend() {
    }

    public void resume() {
    }

    public boolean commit() {
        this.complete();
        return true;
    }

    public void rollback() {
        this.setRollbackOnly();
        this.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete() {
        try {
            if (!this.failed) {
                this.flushState();
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable e) {
            log.error((Object)"Unable to flush state, continuing", e);
        }
        finally {
            this.active = false;
            this.unassociateAll();
        }
    }
}

