/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.resource.spi.XATerminator;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.gbean.ReferenceCollectionEvent;
import org.apache.geronimo.gbean.ReferenceCollectionListener;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.transaction.TransactionProxy;
import org.apache.geronimo.transaction.XAWork;
import org.apache.geronimo.transaction.context.TransactionContext;
import org.apache.geronimo.transaction.context.UnspecifiedTransactionContext;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.Recovery;
import org.apache.geronimo.transaction.manager.ResourceManager;
import org.apache.geronimo.transaction.manager.XidImporter;

public class TransactionManagerProxy
implements TransactionManager,
XATerminator,
XAWork,
GBeanLifecycle {
    private static final boolean NOT_IN_RECOVERY = false;
    private static final boolean IN_RECOVERY = true;
    private static final Log recoveryLog;
    private final TransactionManager delegate;
    private final XidImporter importer;
    private final ThreadLocal threadTx = new ThreadLocal();
    private final Map importedTransactions = new HashMap();
    private boolean recoveryState = false;
    private final Recovery recovery;
    private final ReferenceCollection resourceManagers;
    private List recoveryErrors = new ArrayList();
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TransactionManagerProxy(TransactionManager delegate, XidImporter importer, Recovery recovery, Collection resourceManagers) {
        if (!$assertionsDisabled && delegate == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && importer == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && recovery == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && resourceManagers == null) {
            throw new AssertionError();
        }
        this.delegate = delegate;
        this.importer = importer;
        this.recovery = recovery;
        this.resourceManagers = (ReferenceCollection)resourceManagers;
    }

    public TransactionManagerProxy(ConstructorParams params) {
        this(params.delegate, params.xidImporter, params.recovery, (Collection)params.resourceManagers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws WaitingException, Exception {
        this.recovery.recoverLog();
        ArrayList copy = null;
        ReferenceCollection referenceCollection = this.resourceManagers;
        synchronized (referenceCollection) {
            copy = new ArrayList(this.resourceManagers);
            this.resourceManagers.addReferenceCollectionListener(new ReferenceCollectionListener(){

                public void memberAdded(ReferenceCollectionEvent event) {
                    ResourceManager resourceManager = (ResourceManager)event.getMember();
                    TransactionManagerProxy.this.recoverResourceManager(resourceManager);
                }

                public void memberRemoved(ReferenceCollectionEvent event) {
                }
            });
        }
        Iterator iterator = copy.iterator();
        while (iterator.hasNext()) {
            ResourceManager resourceManager = (ResourceManager)iterator.next();
            this.recoverResourceManager(resourceManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverResourceManager(ResourceManager resourceManager) {
        block11: {
            TransactionContext oldTransactionContext = TransactionContext.getContext();
            try {
                TransactionContext.setContext(new UnspecifiedTransactionContext());
                NamedXAResource namedXAResource = null;
                try {
                    namedXAResource = resourceManager.getRecoveryXAResources();
                }
                catch (SystemException e) {
                    recoveryLog.error((Object)e);
                    this.recoveryErrors.add(e);
                    TransactionContext.setContext(oldTransactionContext);
                    return;
                }
                if (namedXAResource == null) break block11;
                try {
                    this.recovery.recoverResourceManager(namedXAResource);
                }
                catch (XAException e) {
                    recoveryLog.error((Object)e);
                    this.recoveryErrors.add(e);
                }
                finally {
                    resourceManager.returnResource(namedXAResource);
                }
            }
            finally {
                TransactionContext.setContext(oldTransactionContext);
            }
        }
    }

    public void doStop() throws WaitingException, Exception {
    }

    public void doFail() {
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        this.delegate.setTransactionTimeout(timeout);
    }

    public void begin() throws NotSupportedException, SystemException {
        this.delegate.begin();
        this.threadTx.set(new TransactionProxy(this.delegate.getTransaction()));
    }

    public int getStatus() throws SystemException {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.getStatus() : 6;
    }

    public Transaction getTransaction() throws SystemException {
        return (Transaction)this.threadTx.get();
    }

    public Transaction suspend() throws SystemException {
        Transaction tx = this.getTransaction();
        this.threadTx.set(null);
        return tx;
    }

    public void resume(Transaction tx) throws IllegalStateException, InvalidTransactionException, SystemException {
        if (this.threadTx.get() != null) {
            throw new IllegalStateException("Transaction already associated with current thread");
        }
        if (!(tx instanceof TransactionProxy)) {
            throw new InvalidTransactionException("Cannot resume foreign transaction: " + tx);
        }
        this.threadTx.set(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("No transaction associated with current thread");
        }
        try {
            tx.commit();
        }
        finally {
            this.threadTx.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("No transaction associated with current thread");
        }
        try {
            tx.rollback();
        }
        finally {
            this.threadTx.set(null);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("No transaction associated with current thread");
        }
        tx.setRollbackOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        ImportedTransactionInfo txInfo;
        Map map = this.importedTransactions;
        synchronized (map) {
            txInfo = (ImportedTransactionInfo)this.importedTransactions.remove(xid);
        }
        if (txInfo == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        TransactionProxy tx = txInfo.getTransactionProxy();
        try {
            int status = tx.getStatus();
            if (!$assertionsDisabled && status != 0 && status != 2) {
                throw new AssertionError();
            }
        }
        catch (SystemException e) {
            throw new XAException();
        }
        this.importer.commit(tx.getDelegate(), onePhase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        ImportedTransactionInfo txInfo;
        Map map = this.importedTransactions;
        synchronized (map) {
            txInfo = (ImportedTransactionInfo)this.importedTransactions.remove(xid);
        }
        if (txInfo == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        TransactionProxy tx = txInfo.getTransactionProxy();
        this.importer.forget(tx.getDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        ImportedTransactionInfo txInfo;
        Map map = this.importedTransactions;
        synchronized (map) {
            txInfo = (ImportedTransactionInfo)this.importedTransactions.get(xid);
        }
        if (txInfo == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        TransactionProxy tx = txInfo.getTransactionProxy();
        try {
            int status = tx.getStatus();
            if (!$assertionsDisabled && status != 0) {
                throw new AssertionError();
            }
        }
        catch (SystemException e) {
            throw new XAException();
        }
        return this.importer.prepare(tx.getDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid[] recover(int flag) throws XAException {
        if (!this.recoveryState) {
            if ((flag & 0x1000000) == 0) {
                throw new XAException(-6);
            }
            this.recoveryState = true;
        }
        if ((flag & 0x800000) != 0) {
            this.recoveryState = false;
        }
        if ((flag & 0x1000000) != 0) {
            Map recoveredXidMap = this.recovery.getExternalXids();
            Xid[] recoveredXids = new Xid[recoveredXidMap.size()];
            int i = 0;
            Map map = this.importedTransactions;
            synchronized (map) {
                Iterator iterator = recoveredXidMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Xid xid = (Xid)entry.getKey();
                    recoveredXids[i++] = xid;
                    ImportedTransactionInfo txInfo = new ImportedTransactionInfo(new TransactionProxy((Transaction)entry.getValue()));
                    this.importedTransactions.put(xid, txInfo);
                }
            }
            return recoveredXids;
        }
        return new Xid[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        ImportedTransactionInfo txInfo;
        Map map = this.importedTransactions;
        synchronized (map) {
            txInfo = (ImportedTransactionInfo)this.importedTransactions.remove(xid);
        }
        if (txInfo == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        TransactionProxy tx = txInfo.getTransactionProxy();
        try {
            int status = tx.getStatus();
            if (!$assertionsDisabled && status != 0 && status != 2) {
                throw new AssertionError();
            }
        }
        catch (SystemException e) {
            throw new XAException();
        }
        this.importer.rollback(tx.getDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(Xid xid, long txTimeoutMillis) throws XAException, InvalidTransactionException, SystemException {
        ImportedTransactionInfo txInfo;
        boolean old = true;
        Map map = this.importedTransactions;
        synchronized (map) {
            txInfo = (ImportedTransactionInfo)this.importedTransactions.get(xid);
            if (txInfo == null) {
                try {
                    txInfo = new ImportedTransactionInfo(new TransactionProxy(this.importer.importXid(xid)));
                    old = false;
                }
                catch (SystemException e) {
                    throw (XAException)new XAException("Could not import xid").initCause(e);
                }
                this.importedTransactions.put(xid, txInfo);
            }
            if (txInfo.isActive()) {
                throw new XAException("Xid already active");
            }
            txInfo.setActive(true);
        }
        this.threadTx.set(txInfo.getTransactionProxy());
        if (old) {
            this.delegate.resume(txInfo.getTransactionProxy().getDelegate());
        }
        this.importer.setTransactionTimeout(txTimeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid) throws XAException, SystemException {
        Map map = this.importedTransactions;
        synchronized (map) {
            ImportedTransactionInfo txInfo = (ImportedTransactionInfo)this.importedTransactions.get(xid);
            if (txInfo == null) {
                throw new XAException("No imported transaction for xid: " + xid);
            }
            if (!txInfo.isActive()) {
                throw new XAException("tx not active for xid: " + xid);
            }
            txInfo.setActive(false);
        }
        this.threadTx.set(null);
        this.delegate.suspend();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !TransactionManagerProxy.class.desiredAssertionStatus();
        recoveryLog = LogFactory.getLog((String)"RecoveryController");
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(TransactionManagerProxy.class);
        infoFactory.addReference("delegate", TransactionManager.class);
        infoFactory.addReference("xidImporter", XidImporter.class);
        infoFactory.addReference("recovery", Recovery.class);
        infoFactory.addReference("resourceManagers", ResourceManager.class);
        infoFactory.addOperation("setTransactionTimeout", new Class[]{Integer.TYPE});
        infoFactory.addOperation("begin");
        infoFactory.addOperation("getStatus");
        infoFactory.addOperation("getTransaction");
        infoFactory.addOperation("suspend");
        infoFactory.addOperation("resume", new Class[]{Transaction.class});
        infoFactory.addOperation("commit");
        infoFactory.addOperation("rollback");
        infoFactory.addOperation("setRollbackOnly");
        infoFactory.setConstructor(new String[]{"delegate", "xidImporter", "recovery", "resourceManagers"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private static class ImportedTransactionInfo {
        private final TransactionProxy transactionProxy;
        private boolean active;

        public ImportedTransactionInfo(TransactionProxy transactionProxy) {
            this.transactionProxy = transactionProxy;
        }

        public TransactionProxy getTransactionProxy() {
            return this.transactionProxy;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }

    public static class ConstructorParams {
        TransactionManager delegate;
        XidImporter xidImporter;
        Recovery recovery;
        ReferenceCollection resourceManagers;
    }
}

