/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.interceptor;

import java.util.Set;
import javax.resource.ResourceException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.geronimo.tomcat.interceptor.BeforeAfter;
import org.apache.geronimo.transaction.DefaultInstanceContext;
import org.apache.geronimo.transaction.InstanceContext;
import org.apache.geronimo.transaction.TrackedConnectionAssociator;

public class InstanceContextBeforeAfter
implements BeforeAfter {
    private final BeforeAfter next;
    private final int index;
    private final Set unshareableResources;
    private final Set applicationManagedSecurityResources;
    private final TrackedConnectionAssociator trackedConnectionAssociator;

    public InstanceContextBeforeAfter(BeforeAfter next, int index, Set unshareableResources, Set applicationManagedSecurityResources, TrackedConnectionAssociator trackedConnectionAssociator) {
        this.next = next;
        this.index = index;
        this.unshareableResources = unshareableResources;
        this.applicationManagedSecurityResources = applicationManagedSecurityResources;
        this.trackedConnectionAssociator = trackedConnectionAssociator;
    }

    public void before(Object[] context, ServletRequest httpRequest, ServletResponse httpResponse) {
        try {
            context[this.index] = this.trackedConnectionAssociator.enter((InstanceContext)new DefaultInstanceContext(this.unshareableResources, this.applicationManagedSecurityResources));
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
        if (this.next != null) {
            this.next.before(context, httpRequest, httpResponse);
        }
    }

    public void after(Object[] context, ServletRequest httpRequest, ServletResponse httpResponse) {
        if (this.next != null) {
            this.next.after(context, httpRequest, httpResponse);
        }
        try {
            this.trackedConnectionAssociator.exit((InstanceContext)context[this.index]);
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
    }
}

