/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.util.Map;
import org.apache.catalina.Valve;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.tomcat.BaseGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;

public class ValveGBean
extends BaseGBean
implements GBeanLifecycle,
ObjectRetriever {
    private static final Log log = LogFactory.getLog((Class)ValveGBean.class);
    public static final String J2EE_TYPE = "TomcatValve";
    private final Valve valve;
    private final ValveGBean nextValve;
    private final String className;
    public static final GBeanInfo GBEAN_INFO;

    public ValveGBean() {
        this.valve = null;
        this.nextValve = null;
        this.className = null;
    }

    public ValveGBean(String className, Map initParams, ValveGBean nextValve) throws Exception {
        if (className == null) {
            throw new IllegalArgumentException("className cannot be null.");
        }
        if (nextValve != null) {
            if (!(nextValve.getInternalObject() instanceof Valve)) {
                throw new IllegalArgumentException("The class given as the NextValve attribute does not wrap an object of org.apache.catalina.Valve type.");
            }
            this.nextValve = nextValve;
        } else {
            this.nextValve = null;
        }
        this.className = className;
        this.valve = (Valve)Class.forName(className).newInstance();
        this.setParameters(this.valve, initParams);
    }

    public void doStart() throws Exception {
        log.debug((Object)(this.className + " started."));
    }

    public void doStop() throws Exception {
        log.debug((Object)(this.className + " stopped."));
    }

    public void doFail() {
        log.warn((Object)(this.className + " failed."));
    }

    public Object getInternalObject() {
        return this.valve;
    }

    public ValveGBean getNextValve() {
        return this.nextValve;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)ValveGBean.class, (String)J2EE_TYPE);
        infoFactory.addAttribute("className", String.class, true);
        infoFactory.addAttribute("initParams", Map.class, true);
        infoFactory.addReference("NextValve", ValveGBean.class, J2EE_TYPE);
        infoFactory.addOperation("getInternalObject");
        infoFactory.addOperation("getNextValve");
        infoFactory.setConstructor(new String[]{"className", "initParams", "NextValve"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

