/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.BasicAuthenticator;
import org.apache.catalina.authenticator.DigestAuthenticator;
import org.apache.catalina.authenticator.SSLAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.tomcat.realm.TomcatEJBWSGeronimoRealm;
import org.apache.geronimo.webservices.WebServiceContainer;

public class TomcatEJBWebServiceContext
extends StandardContext {
    private static final Log log = LogFactory.getLog((Class)TomcatEJBWebServiceContext.class);
    private final String contextPath;
    private final WebServiceContainer webServiceContainer;
    private final boolean isSecureTransportGuarantee;
    private final ClassLoader classLoader;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TomcatEJBWebServiceContext(String contextPath, WebServiceContainer webServiceContainer, String securityRealmName, String realmName, String transportGuarantee, String authMethod, ClassLoader classLoader) {
        this.contextPath = contextPath;
        this.webServiceContainer = webServiceContainer;
        this.setPath(contextPath);
        this.setDocBase("");
        this.setParentClassLoader(classLoader);
        this.setDelegate(true);
        log.debug((Object)("EJB Webservice Context = " + contextPath));
        if (securityRealmName != null) {
            TomcatEJBWSGeronimoRealm realm = new TomcatEJBWSGeronimoRealm();
            realm.setAppName(securityRealmName);
            realm.setUserClassNames("org.apache.geronimo.security.realm.providers.GeronimoUserPrincipal");
            realm.setRoleClassNames("org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal");
            this.setRealm((Realm)realm);
            this.realm = realm;
            if ("NONE".equals(transportGuarantee)) {
                this.isSecureTransportGuarantee = false;
            } else {
                if (!"INTEGRAL".equals(transportGuarantee) && !"CONFIDENTIAL".equals(transportGuarantee)) throw new IllegalArgumentException("Invalid transport-guarantee: " + transportGuarantee);
                this.isSecureTransportGuarantee = true;
            }
            if (!"BASIC".equals(authMethod) && !"DIGEST".equals(authMethod) && !"CLIENT-CERT".equals(authMethod)) throw new IllegalArgumentException("Invalid authMethod: " + authMethod);
            LoginConfig loginConfig = new LoginConfig();
            loginConfig.setAuthMethod(authMethod);
            loginConfig.setRealmName(realmName);
            this.setLoginConfig(loginConfig);
            SecurityCollection collection = new SecurityCollection();
            collection.addMethod("GET");
            collection.addMethod("POST");
            collection.addPattern("/*");
            collection.setName("default");
            SecurityConstraint sc = new SecurityConstraint();
            sc.addAuthRole("*");
            sc.addCollection(collection);
            sc.setAuthConstraint(true);
            sc.setUserConstraint(transportGuarantee);
            this.addConstraint(sc);
            this.addSecurityRole("default");
            if ("BASIC".equals(authMethod)) {
                this.addValve((Valve)new BasicAuthenticator());
            } else if ("DIGEST".equals(authMethod)) {
                this.addValve((Valve)new DigestAuthenticator());
            } else if ("CLIENT-CERT".equals(authMethod)) {
                this.addValve((Valve)new SSLAuthenticator());
            }
        } else {
            this.isSecureTransportGuarantee = false;
        }
        this.classLoader = classLoader;
        this.addValve((Valve)new EJBWebServiceValve());
    }

    public static class ResponseAdapter
    implements WebServiceContainer.Response {
        private final Response response;

        public ResponseAdapter(Response response) {
            this.response = response;
        }

        public void setHeader(String name, String value) {
            this.response.setHeader(name, value);
        }

        public String getHeader(String name) {
            return this.response.getHeader(name);
        }

        public OutputStream getOutputStream() {
            return this.response.getStream();
        }

        public void setStatusCode(int code) {
            this.response.setStatus(code);
        }

        public int getStatusCode() {
            return this.response.getStatus();
        }

        public void setContentType(String type) {
            this.response.setContentType(type);
        }

        public String getContentType() {
            return this.response.getContentType();
        }

        public void setStatusMessage(String responseString) {
            this.response.setStatus(this.response.getStatus(), responseString);
        }
    }

    public static class RequestAdapter
    implements WebServiceContainer.Request {
        private final Request request;
        private URI uri;
        private static final Map methods = new HashMap();

        public RequestAdapter(Request request) {
            this.request = request;
        }

        public String getHeader(String name) {
            return this.request.getHeader(name);
        }

        public URI getURI() {
            if (this.uri == null) {
                try {
                    String uriString = this.request.getScheme() + "://" + this.request.getServerName() + ":" + this.request.getLocalPort() + this.request.getRequestURI();
                    this.uri = new URI(uriString);
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
            return this.uri;
        }

        public int getContentLength() {
            return this.request.getContentLength();
        }

        public String getContentType() {
            return this.request.getContentType();
        }

        public InputStream getInputStream() throws IOException {
            return this.request.getInputStream();
        }

        public int getMethod() {
            Integer method = (Integer)methods.get(this.request.getMethod());
            return method == null ? 8 : method;
        }

        public String getParameter(String name) {
            return this.request.getParameter(name);
        }

        public Map getParameters() {
            return this.request.getParameterMap();
        }

        public Object getAttribute(String name) {
            return this.request.getAttribute(name);
        }

        public void setAttribute(String name, Object value) {
            this.request.setAttribute(name, value);
        }

        static {
            methods.put("OPTIONS", new Integer(0));
            methods.put("GET", new Integer(1));
            methods.put("HEAD", new Integer(2));
            methods.put("POST", new Integer(3));
            methods.put("PUT", new Integer(4));
            methods.put("DELETE", new Integer(5));
            methods.put("TRACE", new Integer(6));
            methods.put("CONNECT", new Integer(7));
        }
    }

    public class EJBWebServiceValve
    extends ValveBase {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(Request req, Response res) throws IOException, ServletException {
            req.setContentType("text/xml");
            RequestAdapter request = new RequestAdapter(req);
            ResponseAdapter response = new ResponseAdapter(res);
            req.finishRequest();
            if (req.getParameter("wsdl") != null) {
                try {
                    TomcatEJBWebServiceContext.this.webServiceContainer.getWsdl((WebServiceContainer.Request)request, (WebServiceContainer.Response)response);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.error((Object)e);
                    res.sendError(500, "Could not fetch wsdl!");
                    return;
                }
            }
            if (TomcatEJBWebServiceContext.this.isSecureTransportGuarantee && !req.isSecure()) {
                res.sendError(403);
                return;
            }
            Thread currentThread = Thread.currentThread();
            ClassLoader oldClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(TomcatEJBWebServiceContext.this.classLoader);
            try {
                try {
                    TomcatEJBWebServiceContext.this.webServiceContainer.invoke((WebServiceContainer.Request)request, (WebServiceContainer.Response)response);
                    req.finishRequest();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    res.sendError(500, "Could not process message!");
                }
            }
            finally {
                currentThread.setContextClassLoader(oldClassLoader);
            }
        }
    }
}

