/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.deployment;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import javax.transaction.UserTransaction;
import org.apache.axis.Handler;
import org.apache.axis.description.JavaServiceDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.HandlerInfoChainFactory;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.axis.builder.AxisServiceBuilder;
import org.apache.geronimo.axis.builder.PortInfo;
import org.apache.geronimo.axis.server.AxisWebServiceContainer;
import org.apache.geronimo.axis.server.POJOProvider;
import org.apache.geronimo.axis.server.ServiceInfo;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.service.ServiceConfigBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.xbeans.DependencyType;
import org.apache.geronimo.deployment.xbeans.GbeanType;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.deployment.WebServiceBuilder;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContextImpl;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.kernel.ClassLoaderReference;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.StoredObject;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.naming.deployment.ENCConfigBuilder;
import org.apache.geronimo.naming.deployment.GBeanResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentBuilder;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.security.deploy.DefaultPrincipal;
import org.apache.geronimo.security.deployment.SecurityBuilder;
import org.apache.geronimo.security.deployment.SecurityConfiguration;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.security.util.URLPattern;
import org.apache.geronimo.tomcat.RealmGBean;
import org.apache.geronimo.tomcat.TomcatClassLoader;
import org.apache.geronimo.tomcat.TomcatWebAppContext;
import org.apache.geronimo.tomcat.util.SecurityHolder;
import org.apache.geronimo.transaction.context.OnlineUserTransaction;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbLocalRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceEnvRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.geronimo.xbeans.geronimo.security.GerSecurityType;
import org.apache.geronimo.xbeans.geronimo.web.GerConfigParamType;
import org.apache.geronimo.xbeans.geronimo.web.GerContainerConfigType;
import org.apache.geronimo.xbeans.geronimo.web.GerWebAppDocument;
import org.apache.geronimo.xbeans.geronimo.web.GerWebAppType;
import org.apache.geronimo.xbeans.j2ee.EjbLocalRefType;
import org.apache.geronimo.xbeans.j2ee.EjbRefType;
import org.apache.geronimo.xbeans.j2ee.EnvEntryType;
import org.apache.geronimo.xbeans.j2ee.FilterMappingType;
import org.apache.geronimo.xbeans.j2ee.HttpMethodType;
import org.apache.geronimo.xbeans.j2ee.MessageDestinationRefType;
import org.apache.geronimo.xbeans.j2ee.ResourceEnvRefType;
import org.apache.geronimo.xbeans.j2ee.ResourceRefType;
import org.apache.geronimo.xbeans.j2ee.RoleNameType;
import org.apache.geronimo.xbeans.j2ee.SecurityConstraintType;
import org.apache.geronimo.xbeans.j2ee.SecurityRoleRefType;
import org.apache.geronimo.xbeans.j2ee.SecurityRoleType;
import org.apache.geronimo.xbeans.j2ee.ServiceRefType;
import org.apache.geronimo.xbeans.j2ee.ServletMappingType;
import org.apache.geronimo.xbeans.j2ee.ServletType;
import org.apache.geronimo.xbeans.j2ee.UrlPatternType;
import org.apache.geronimo.xbeans.j2ee.WebAppDocument;
import org.apache.geronimo.xbeans.j2ee.WebAppType;
import org.apache.geronimo.xbeans.j2ee.WebResourceCollectionType;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class TomcatModuleBuilder
implements ModuleBuilder {
    private static Log log;
    private final URI defaultParentId;
    private final ObjectName tomcatContainerObjectName;
    private final WebServiceBuilder webServiceBuilder;
    private final Repository repository;
    private final Kernel kernel;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TomcatModuleBuilder(URI defaultParentId, ObjectName tomcatContainerObjectName, WebServiceBuilder webServiceBuilder, Repository repository, Kernel kernel) {
        this.defaultParentId = defaultParentId;
        this.tomcatContainerObjectName = tomcatContainerObjectName;
        this.webServiceBuilder = webServiceBuilder;
        this.repository = repository;
        this.kernel = kernel;
    }

    public Module createModule(File plan, JarFile moduleFile) throws DeploymentException {
        return this.createModule((Object)plan, moduleFile, "war", null, true, null);
    }

    public Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, URI earConfigId, Object moduleContextInfo) throws DeploymentException {
        return this.createModule(plan, moduleFile, targetPath, specDDUrl, false, (String)moduleContextInfo);
    }

    private Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, boolean standAlone, String contextRoot) throws DeploymentException {
        WebAppType webApp;
        String specDD;
        if (!$assertionsDisabled && moduleFile == null) {
            throw new AssertionError((Object)"moduleFile is null");
        }
        if (!$assertionsDisabled && targetPath == null) {
            throw new AssertionError((Object)"targetPath is null");
        }
        if (!$assertionsDisabled && targetPath.endsWith("/")) {
            throw new AssertionError((Object)"targetPath must not end with a '/'");
        }
        try {
            if (specDDUrl == null) {
                specDDUrl = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"WEB-INF/web.xml");
            }
            specDD = DeploymentUtil.readAll((URL)specDDUrl);
        }
        catch (Exception e) {
            return null;
        }
        try {
            XmlObject parsed = SchemaConversionUtils.parse((String)specDD);
            WebAppDocument webAppDoc = SchemaConversionUtils.convertToServletSchema((XmlObject)parsed);
            webApp = webAppDoc.getWebApp();
        }
        catch (XmlException xmle) {
            throw new DeploymentException("Error parsing web.xml", (Throwable)xmle);
        }
        TomcatModuleBuilder.check(webApp);
        GerWebAppType tomcatWebApp = this.getTomcatWebApp(plan, moduleFile, standAlone, targetPath, webApp);
        URI configId = null;
        try {
            configId = new URI(tomcatWebApp.getConfigId());
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Invalid configId " + tomcatWebApp.getConfigId(), (Throwable)e);
        }
        URI parentId = null;
        if (tomcatWebApp.isSetParentId()) {
            try {
                parentId = new URI(tomcatWebApp.getParentId());
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Invalid parentId " + tomcatWebApp.getParentId(), (Throwable)e);
            }
        } else {
            parentId = this.defaultParentId;
        }
        if (contextRoot == null) {
            contextRoot = tomcatWebApp.getContextRoot();
        }
        Map portMap = Collections.EMPTY_MAP;
        Map servletNameToPathMap = this.buildServletNameToPathMap(webApp, contextRoot);
        if (this.webServiceBuilder != null) {
            try {
                URL wsDDUrl = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"WEB-INF/webservices.xml");
                portMap = this.webServiceBuilder.parseWebServiceDescriptor(wsDDUrl, moduleFile, false, servletNameToPathMap);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        WebModule module = new WebModule(standAlone, configId, parentId, moduleFile, targetPath, (XmlObject)webApp, (XmlObject)tomcatWebApp, specDD, portMap);
        module.setContextRoot(contextRoot);
        return module;
    }

    private Map buildServletNameToPathMap(WebAppType webApp, String contextRoot) {
        contextRoot = "/" + contextRoot;
        HashMap<String, String> map = new HashMap<String, String>();
        ServletMappingType[] servletMappings = webApp.getServletMappingArray();
        for (int j = 0; j < servletMappings.length; ++j) {
            ServletMappingType servletMapping = servletMappings[j];
            String servletName = servletMapping.getServletName().getStringValue().trim();
            map.put(servletName, contextRoot + servletMapping.getUrlPattern().getStringValue());
        }
        return map;
    }

    GerWebAppType getTomcatWebApp(Object plan, JarFile moduleFile, boolean standAlone, String targetPath, WebAppType webApp) throws DeploymentException {
        GerWebAppType tomcatWebApp = null;
        try {
            try {
                if (plan instanceof XmlObject) {
                    tomcatWebApp = (GerWebAppType)SchemaConversionUtils.getNestedObjectAsType((XmlObject)((XmlObject)plan), (String)"web-app", (SchemaType)GerWebAppType.type);
                } else {
                    GerWebAppDocument tomcatWebAppdoc = null;
                    if (plan != null) {
                        tomcatWebAppdoc = GerWebAppDocument.Factory.parse((File)((File)plan));
                    } else {
                        URL path = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"WEB-INF/geronimo-web.xml");
                        tomcatWebAppdoc = GerWebAppDocument.Factory.parse((URL)path);
                    }
                    if (tomcatWebAppdoc != null) {
                        tomcatWebApp = tomcatWebAppdoc.getWebApp();
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (tomcatWebApp != null) {
                tomcatWebApp = (GerWebAppType)SchemaConversionUtils.convertToGeronimoNamingSchema(tomcatWebApp);
                tomcatWebApp = (GerWebAppType)SchemaConversionUtils.convertToGeronimoSecuritySchema((XmlObject)tomcatWebApp);
                tomcatWebApp = (GerWebAppType)SchemaConversionUtils.convertToGeronimoServiceSchema((XmlObject)tomcatWebApp);
                SchemaConversionUtils.validateDD((XmlObject)tomcatWebApp);
            } else {
                String path = standAlone ? new File(moduleFile.getName()).getName() : targetPath;
                tomcatWebApp = this.createDefaultPlan(path, webApp);
            }
        }
        catch (XmlException e) {
            throw new DeploymentException("xml problem", (Throwable)e);
        }
        return tomcatWebApp;
    }

    private GerWebAppType createDefaultPlan(String path, WebAppType webApp) {
        String id = webApp.getId();
        if (id == null) {
            id = path;
            if (id.endsWith(".war")) {
                id = id.substring(0, id.length() - 4);
            }
            if (id.endsWith("/")) {
                id = id.substring(0, id.length() - 1);
            }
        }
        GerWebAppType tomcatWebApp = GerWebAppType.Factory.newInstance();
        tomcatWebApp.setParentId(this.defaultParentId.toString());
        if (null != webApp.getId()) {
            id = webApp.getId();
        }
        tomcatWebApp.setConfigId(id);
        tomcatWebApp.setContextRoot("/" + id);
        return tomcatWebApp;
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module) throws DeploymentException {
        try {
            URI baseDir = URI.create(module.getTargetPath() + "/");
            JarFile warFile = module.getModuleFile();
            Enumeration<JarEntry> entries = warFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                URI targetPath = baseDir.resolve(new URI(null, entry.getName(), null));
                if (entry.getName().equals("WEB-INF/web.xml")) {
                    earContext.addFile(targetPath, module.getOriginalSpecDD());
                    continue;
                }
                earContext.addFile(targetPath, (ZipFile)warFile, entry);
            }
            earContext.addManifestClassPath(warFile, URI.create(module.getTargetPath()));
            GerWebAppType tomcatWebApp = (GerWebAppType)module.getVendorDD();
            DependencyType[] dependencies = tomcatWebApp.getDependencyArray();
            ServiceConfigBuilder.addDependencies((DeploymentContext)earContext, (DependencyType[])dependencies, (Repository)this.repository);
        }
        catch (IOException e) {
            throw new DeploymentException("Problem deploying war", (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Could not construct URI for location of war entry", (Throwable)e);
        }
    }

    public void initContext(EARContext earContext, Module module, ClassLoader cl) {
    }

    public void addGBeans(EARContext earContext, Module module, ClassLoader cl) throws DeploymentException {
        J2eeContext earJ2eeContext = earContext.getJ2eeContext();
        J2eeContextImpl moduleJ2eeContext = J2eeContextImpl.newModuleContextFromApplication((J2eeContext)earJ2eeContext, (String)NameFactory.WEB_MODULE, (String)module.getName());
        WebModule webModule = (WebModule)module;
        WebAppType webApp = (WebAppType)webModule.getSpecDD();
        GerWebAppType tomcatWebApp = (GerWebAppType)webModule.getVendorDD();
        boolean contextPriorityClassLoader = false;
        if (tomcatWebApp != null) {
            contextPriorityClassLoader = tomcatWebApp.getContextPriorityClassloader();
        }
        ClassLoader webClassLoader = this.getWebClassLoader(earContext, webModule, cl, contextPriorityClassLoader);
        if (tomcatWebApp != null) {
            GbeanType[] gbeans = tomcatWebApp.getGbeanArray();
            ServiceConfigBuilder.addGBeans((GbeanType[])gbeans, (ClassLoader)webClassLoader, (J2eeContext)moduleJ2eeContext, (DeploymentContext)earContext);
        }
        ObjectName webModuleName = null;
        try {
            webModuleName = NameFactory.getModuleName(null, null, null, null, null, (J2eeContext)moduleJ2eeContext);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Could not construct module name", (Throwable)e);
        }
        OnlineUserTransaction userTransaction = new OnlineUserTransaction();
        Map compContext = this.buildComponentContext(earContext, (Module)webModule, webApp, tomcatWebApp, (UserTransaction)userTransaction, webClassLoader);
        GBeanData webModuleData = new GBeanData(webModuleName, TomcatWebAppContext.GBEAN_INFO);
        try {
            webModuleData.setReferencePattern("J2EEServer", earContext.getServerObjectName());
            if (!earContext.getJ2EEApplicationName().equals("null")) {
                webModuleData.setReferencePattern("J2EEApplication", earContext.getApplicationObjectName());
            }
            webModuleData.setAttribute("deploymentDescriptor", (Object)module.getOriginalSpecDD());
            Set securityRoles = TomcatModuleBuilder.collectRoleNames(webApp);
            HashMap rolePermissions = new HashMap();
            URI baseUri = earContext.getTargetFile(URI.create(webModule.getTargetPath() + "/")).toURI();
            webModuleData.setAttribute("webAppRoot", (Object)baseUri);
            webModuleData.setAttribute("path", (Object)webModule.getContextRoot());
            webModuleData.setAttribute("componentContext", (Object)compContext);
            webModuleData.setAttribute("userTransaction", (Object)userTransaction);
            webModuleData.setAttribute("webClassPath", (Object)TomcatModuleBuilder.getFinalWebClasspath(webModule));
            GBeanResourceEnvironmentBuilder rebuilder = new GBeanResourceEnvironmentBuilder(webModuleData);
            ENCConfigBuilder.setResourceEnvironment((EARContext)earContext, (URI)webModule.getModuleURI(), (ResourceEnvironmentBuilder)rebuilder, (ResourceRefType[])webApp.getResourceRefArray(), (GerResourceRefType[])tomcatWebApp.getResourceRefArray());
            webModuleData.setAttribute("contextPriorityClassLoader", (Object)contextPriorityClassLoader);
            webModuleData.setReferencePattern("transactionContextManager", earContext.getTransactionContextManagerObjectName());
            webModuleData.setReferencePattern("trackedConnectionAssociator", earContext.getConnectionTrackerObjectName());
            webModuleData.setReferencePattern("Container", this.tomcatContainerObjectName);
            String virtualServer = null;
            if (tomcatWebApp != null && tomcatWebApp.sizeOfContainerConfigArray() > 0) {
                String tomcatValveChain;
                HashMap<String, String> values = new HashMap<String, String>();
                GerContainerConfigType[] configs = tomcatWebApp.getContainerConfigArray();
                for (int i = 0; i < configs.length; ++i) {
                    GerContainerConfigType config = configs[i];
                    if (config.getContainer().intValue() != 1) continue;
                    GerConfigParamType[] params = config.getConfigParamArray();
                    for (int j = 0; j < params.length; ++j) {
                        GerConfigParamType param = params[j];
                        values.put(param.getName(), param.getStringValue());
                    }
                }
                virtualServer = (String)values.remove("VirtualServer");
                String tomcatRealm = (String)values.remove("TomcatRealm");
                if (tomcatRealm != null) {
                    ObjectName realmName = NameFactory.getComponentName(null, null, null, null, (String)tomcatRealm.trim(), (String)RealmGBean.GBEAN_INFO.getJ2eeType(), (J2eeContext)moduleJ2eeContext);
                    webModuleData.setReferencePattern("TomcatRealm", realmName);
                }
                if ((tomcatValveChain = (String)values.remove("TomcatValveChain")) != null) {
                    ObjectName valveName = NameFactory.getComponentName(null, null, null, null, (String)tomcatValveChain.trim(), (String)"TomcatValve", (J2eeContext)moduleJ2eeContext);
                    webModuleData.setReferencePattern("TomcatValveChain", valveName);
                }
                if (values.size() > 0) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("Unexpected container-config/config-params found for Tomcat in web app deployment plan (");
                    boolean first = true;
                    Iterator it = values.keySet().iterator();
                    while (it.hasNext()) {
                        String value = (String)it.next();
                        if (!first) {
                            msg.append(",");
                        }
                        msg.append(value);
                    }
                    msg.append(")");
                    throw new DeploymentException(msg.toString());
                }
            }
            Map portMap = webModule.getPortMap();
            ServletType[] servletTypes = webApp.getServletArray();
            HashMap<String, StoredObject> webServices = new HashMap<String, StoredObject>();
            for (int i = 0; i < servletTypes.length; ++i) {
                String servletName;
                ServletType servletType = servletTypes[i];
                this.processRoleRefPermissions(servletType, securityRoles, rolePermissions);
                if (portMap == null || !portMap.containsKey(servletName = servletType.getServletName().getStringValue().trim())) continue;
                String servletClassName = servletType.getServletClass().getStringValue().trim();
                Object portInfo = portMap.get(servletName);
                if (portInfo == null) {
                    throw new DeploymentException("No web service deployment info for servlet name " + servletName);
                }
                StoredObject wsContainer = this.configurePOJO(webModule.getModuleFile(), portInfo, servletClassName, webClassLoader);
                webServices.put(servletName, wsContainer);
            }
            webModuleData.setAttribute("webServices", webServices);
            if (tomcatWebApp.isSetSecurityRealmName()) {
                SecurityHolder securityHolder = new SecurityHolder();
                String securityRealmName = tomcatWebApp.getSecurityRealmName().trim();
                String policyContextID = webModuleName.getCanonicalName().replaceAll("[, :]", "_");
                securityHolder.setPolicyContextID(policyContextID);
                ComponentPermissions componentPermissions = this.buildSpecSecurityConfig(webApp, securityRoles, rolePermissions);
                securityHolder.setExcluded(componentPermissions.getExcludedPermissions());
                Permissions checkedPermissions = new Permissions();
                Iterator iterator = rolePermissions.values().iterator();
                while (iterator.hasNext()) {
                    PermissionCollection permissionsForRole = (PermissionCollection)iterator.next();
                    Enumeration<Permission> iterator2 = permissionsForRole.elements();
                    while (iterator2.hasMoreElements()) {
                        Permission permission = iterator2.nextElement();
                        ((PermissionCollection)checkedPermissions).add(permission);
                    }
                }
                securityHolder.setChecked((PermissionCollection)checkedPermissions);
                earContext.addSecurityContext(policyContextID, (Object)componentPermissions);
                if (tomcatWebApp.isSetSecurity()) {
                    SecurityConfiguration securityConfiguration = SecurityBuilder.buildSecurityConfiguration((GerSecurityType)tomcatWebApp.getSecurity());
                    earContext.setSecurityConfiguration(securityConfiguration);
                }
                DefaultPrincipal defaultPrincipal = earContext.getSecurityConfiguration().getDefaultPrincipal();
                securityHolder.setDefaultPrincipal(defaultPrincipal);
                webModuleData.setAttribute("securityHolder", (Object)securityHolder);
                webModuleData.setReferencePattern("RoleDesignateSource", earContext.getJaccManagerName());
            }
            if (virtualServer != null) {
                webModuleData.setAttribute("virtualServer", (Object)virtualServer);
            }
            earContext.addGBean(webModuleData);
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to initialize webapp GBean", (Throwable)e);
        }
    }

    private ClassLoader getWebClassLoader(EARContext earContext, WebModule webModule, ClassLoader cl, boolean contextPriorityClassLoader) throws DeploymentException {
        TomcatModuleBuilder.getWebClassPath(earContext, webModule);
        URI[] webClassPath = webModule.getWebClasspath();
        URI baseUri = earContext.getBaseDir().toURI();
        URL baseUrl = null;
        try {
            baseUrl = baseUri.resolve(webModule.getTargetPathURI()).toURL();
        }
        catch (MalformedURLException e) {
            throw new DeploymentException("Invalid module location: " + webModule.getTargetPathURI() + ", baseUri: " + baseUri);
        }
        URL[] webClassPathURLs = new URL[webClassPath.length];
        for (int i = 0; i < webClassPath.length; ++i) {
            URI path = baseUri.resolve(webClassPath[i]);
            try {
                webClassPathURLs[i] = path.toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new DeploymentException("Invalid web class path element: path=" + path + ", baseUri=" + baseUri);
            }
        }
        TomcatClassLoader webClassLoader = new TomcatClassLoader(webClassPathURLs, baseUrl, cl, contextPriorityClassLoader);
        return webClassLoader;
    }

    private void processRoleRefPermissions(ServletType servletType, Set securityRoles, Map rolePermissions) throws MalformedObjectNameException, DeploymentException {
        String servletName = servletType.getServletName().getStringValue().trim();
        SecurityRoleRefType[] securityRoleRefTypeArray = servletType.getSecurityRoleRefArray();
        HashSet unmappedRoles = new HashSet(securityRoles);
        for (int j = 0; j < securityRoleRefTypeArray.length; ++j) {
            SecurityRoleRefType securityRoleRefType = securityRoleRefTypeArray[j];
            String roleName = securityRoleRefType.getRoleName().getStringValue().trim();
            String roleLink = securityRoleRefType.getRoleLink().getStringValue().trim();
            this.addPermissionToRole(roleLink, (Permission)new WebRoleRefPermission(servletName, roleName), rolePermissions);
            unmappedRoles.remove(roleName);
        }
        Iterator iterator = unmappedRoles.iterator();
        while (iterator.hasNext()) {
            String roleName = (String)iterator.next();
            this.addPermissionToRole(roleName, (Permission)new WebRoleRefPermission(servletName, roleName), rolePermissions);
        }
    }

    private ComponentPermissions buildSpecSecurityConfig(WebAppType webApp, Set securityRoles, Map rolePermissions) {
        UncheckedItem item;
        String name;
        URLPattern pattern;
        HashMap<String, URLPattern> uncheckedPatterns = new HashMap<String, URLPattern>();
        HashMap uncheckedResourcePatterns = new HashMap();
        HashMap uncheckedUserPatterns = new HashMap();
        HashMap excludedPatterns = new HashMap();
        HashMap rolesPatterns = new HashMap();
        HashSet<URLPattern> allSet = new HashSet<URLPattern>();
        HashMap<String, URLPattern> allMap = new HashMap<String, URLPattern>();
        SecurityConstraintType[] securityConstraintArray = webApp.getSecurityConstraintArray();
        for (int i = 0; i < securityConstraintArray.length; ++i) {
            SecurityConstraintType securityConstraintType = securityConstraintArray[i];
            HashMap<String, Object> currentPatterns = securityConstraintType.isSetAuthConstraint() ? (securityConstraintType.getAuthConstraint().getRoleNameArray().length == 0 ? excludedPatterns : rolesPatterns) : uncheckedPatterns;
            String transport = "";
            if (securityConstraintType.isSetUserDataConstraint()) {
                transport = securityConstraintType.getUserDataConstraint().getTransportGuarantee().getStringValue().trim().toUpperCase();
            }
            WebResourceCollectionType[] webResourceCollectionTypeArray = securityConstraintType.getWebResourceCollectionArray();
            for (int j = 0; j < webResourceCollectionTypeArray.length; ++j) {
                WebResourceCollectionType webResourceCollectionType = webResourceCollectionTypeArray[j];
                UrlPatternType[] urlPatternTypeArray = webResourceCollectionType.getUrlPatternArray();
                for (int k = 0; k < urlPatternTypeArray.length; ++k) {
                    HttpMethodType[] httpMethodTypeArray;
                    URLPattern allPattern;
                    UrlPatternType urlPatternType = urlPatternTypeArray[k];
                    String url = urlPatternType.getStringValue();
                    URLPattern pattern2 = (URLPattern)currentPatterns.get(url);
                    if (pattern2 == null) {
                        pattern2 = new URLPattern(url);
                        currentPatterns.put(url, pattern2);
                    }
                    if ((allPattern = (URLPattern)allMap.get(url)) == null) {
                        allPattern = new URLPattern(url);
                        allSet.add(allPattern);
                        allMap.put(url, allPattern);
                    }
                    if ((httpMethodTypeArray = webResourceCollectionType.getHttpMethodArray()).length == 0) {
                        pattern2.addMethod("");
                        allPattern.addMethod("");
                    } else {
                        for (int l = 0; l < httpMethodTypeArray.length; ++l) {
                            HttpMethodType httpMethodType = httpMethodTypeArray[l];
                            String method = httpMethodType.getStringValue().trim();
                            pattern2.addMethod(method);
                            allPattern.addMethod(method);
                        }
                    }
                    if (currentPatterns == rolesPatterns) {
                        RoleNameType[] roleNameTypeArray = securityConstraintType.getAuthConstraint().getRoleNameArray();
                        for (int l = 0; l < roleNameTypeArray.length; ++l) {
                            RoleNameType roleNameType = roleNameTypeArray[l];
                            String role = roleNameType.getStringValue().trim();
                            if (role.equals("*")) {
                                pattern2.addAllRoles((Collection)securityRoles);
                                continue;
                            }
                            pattern2.addRole(role);
                        }
                    }
                    pattern2.setTransport(transport);
                }
            }
        }
        Permissions excludedPermissions = new Permissions();
        Permissions uncheckedPermissions = new Permissions();
        Iterator<Object> iter = excludedPatterns.keySet().iterator();
        while (iter.hasNext()) {
            pattern = (URLPattern)excludedPatterns.get(iter.next());
            name = pattern.getQualifiedPattern(allSet);
            String actions = pattern.getMethods();
            ((PermissionCollection)excludedPermissions).add((Permission)new WebResourcePermission(name, actions));
            ((PermissionCollection)excludedPermissions).add((Permission)new WebUserDataPermission(name, actions));
        }
        iter = rolesPatterns.keySet().iterator();
        while (iter.hasNext()) {
            pattern = (URLPattern)rolesPatterns.get(iter.next());
            name = pattern.getQualifiedPattern(allSet);
            String actions = pattern.getMethods();
            WebResourcePermission permission = new WebResourcePermission(name, actions);
            Iterator names = pattern.getRoles().iterator();
            while (names.hasNext()) {
                String roleName = (String)names.next();
                this.addPermissionToRole(roleName, (Permission)permission, rolePermissions);
            }
        }
        iter = uncheckedPatterns.keySet().iterator();
        while (iter.hasNext()) {
            pattern = (URLPattern)uncheckedPatterns.get(iter.next());
            name = pattern.getQualifiedPattern(allSet);
            String actions = pattern.getMethods();
            this.addOrUpdatePattern(uncheckedResourcePatterns, name, actions);
        }
        iter = rolesPatterns.keySet().iterator();
        while (iter.hasNext()) {
            pattern = (URLPattern)rolesPatterns.get(iter.next());
            name = pattern.getQualifiedPattern(allSet);
            String actions = pattern.getMethodsWithTransport();
            this.addOrUpdatePattern(uncheckedUserPatterns, name, actions);
        }
        iter = uncheckedPatterns.keySet().iterator();
        while (iter.hasNext()) {
            pattern = (URLPattern)uncheckedPatterns.get(iter.next());
            name = pattern.getQualifiedPattern(allSet);
            String actions = pattern.getMethodsWithTransport();
            this.addOrUpdatePattern(uncheckedUserPatterns, name, actions);
        }
        iter = allSet.iterator();
        while (iter.hasNext()) {
            pattern = (URLPattern)iter.next();
            name = pattern.getQualifiedPattern(allSet);
            String actions = pattern.getComplementedMethods();
            if (actions.length() == 0) continue;
            this.addOrUpdatePattern(uncheckedResourcePatterns, name, actions);
            this.addOrUpdatePattern(uncheckedUserPatterns, name, actions);
        }
        pattern = new URLPattern("/");
        if (!allSet.contains(pattern)) {
            name = pattern.getQualifiedPattern(allSet);
            String actions = pattern.getComplementedMethods();
            this.addOrUpdatePattern(uncheckedResourcePatterns, name, actions);
            this.addOrUpdatePattern(uncheckedUserPatterns, name, actions);
        }
        iter = uncheckedResourcePatterns.keySet().iterator();
        while (iter.hasNext()) {
            item = (UncheckedItem)iter.next();
            String actions = (String)uncheckedResourcePatterns.get(item);
            ((PermissionCollection)uncheckedPermissions).add((Permission)new WebResourcePermission(item.getName(), actions));
        }
        iter = uncheckedUserPatterns.keySet().iterator();
        while (iter.hasNext()) {
            item = (UncheckedItem)iter.next();
            String actions = (String)uncheckedUserPatterns.get(item);
            ((PermissionCollection)uncheckedPermissions).add((Permission)new WebUserDataPermission(item.getName(), actions));
        }
        ComponentPermissions componentPermissions = new ComponentPermissions((PermissionCollection)excludedPermissions, (PermissionCollection)uncheckedPermissions, rolePermissions);
        return componentPermissions;
    }

    private void addPermissionToRole(String roleName, Permission permission, Map rolePermissions) {
        PermissionCollection permissionsForRole = (PermissionCollection)rolePermissions.get(roleName);
        if (permissionsForRole == null) {
            permissionsForRole = new Permissions();
            rolePermissions.put(roleName, permissionsForRole);
        }
        permissionsForRole.add(permission);
    }

    private void addOrUpdatePattern(Map patternMap, String name, String actions) {
        UncheckedItem item = new UncheckedItem(name, actions);
        String existingActions = (String)patternMap.get(item);
        if (existingActions != null) {
            patternMap.put(item, actions + "," + existingActions);
            return;
        }
        patternMap.put(item, actions);
    }

    private static Set collectRoleNames(WebAppType webApp) {
        HashSet<String> roleNames = new HashSet<String>();
        SecurityRoleType[] securityRoles = webApp.getSecurityRoleArray();
        for (int i = 0; i < securityRoles.length; ++i) {
            roleNames.add(securityRoles[i].getRoleName().getStringValue().trim());
        }
        return roleNames;
    }

    private static void getWebClassPath(EARContext earContext, WebModule webModule) {
        File[] libs;
        File libDir;
        File baseDir = earContext.getTargetFile(webModule.getTargetPathURI());
        File webInfDir = new File(baseDir, "WEB-INF");
        File classesDir = new File(webInfDir, "classes");
        if (classesDir.isDirectory()) {
            webModule.addToWebClasspath(webModule.getTargetPathURI().resolve(URI.create("WEB-INF/classes/")));
        }
        if ((libDir = new File(webInfDir, "lib")).isDirectory() && (libs = libDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".jar");
            }
        })) != null) {
            for (int i = 0; i < libs.length; ++i) {
                File lib = libs[i];
                webModule.addToWebClasspath(webModule.getTargetPathURI().resolve(URI.create("WEB-INF/lib/" + lib.getName())));
            }
        }
    }

    private Map buildComponentContext(EARContext earContext, Module webModule, WebAppType webApp, GerWebAppType tomcatWebApp, UserTransaction userTransaction, ClassLoader cl) throws DeploymentException {
        return ENCConfigBuilder.buildComponentContext((EARContext)earContext, (Module)webModule, (UserTransaction)userTransaction, (EnvEntryType[])webApp.getEnvEntryArray(), (EjbRefType[])webApp.getEjbRefArray(), (GerEjbRefType[])tomcatWebApp.getEjbRefArray(), (EjbLocalRefType[])webApp.getEjbLocalRefArray(), (GerEjbLocalRefType[])tomcatWebApp.getEjbLocalRefArray(), (ResourceRefType[])webApp.getResourceRefArray(), (GerResourceRefType[])tomcatWebApp.getResourceRefArray(), (ResourceEnvRefType[])webApp.getResourceEnvRefArray(), (GerResourceEnvRefType[])tomcatWebApp.getResourceEnvRefArray(), (MessageDestinationRefType[])webApp.getMessageDestinationRefArray(), (ServiceRefType[])webApp.getServiceRefArray(), (GerServiceRefType[])tomcatWebApp.getServiceRefArray(), (ClassLoader)cl);
    }

    private static void check(WebAppType webApp) throws DeploymentException {
        TomcatModuleBuilder.checkURLPattern(webApp);
        TomcatModuleBuilder.checkMultiplicities(webApp);
    }

    private static void checkURLPattern(WebAppType webApp) throws DeploymentException {
        FilterMappingType[] filterMappings = webApp.getFilterMappingArray();
        for (int i = 0; i < filterMappings.length; ++i) {
            if (!filterMappings[i].isSetUrlPattern()) continue;
            TomcatModuleBuilder.checkString(filterMappings[i].getUrlPattern().getStringValue());
        }
        ServletMappingType[] servletMappings = webApp.getServletMappingArray();
        for (int i = 0; i < servletMappings.length; ++i) {
            TomcatModuleBuilder.checkString(servletMappings[i].getUrlPattern().getStringValue());
        }
        SecurityConstraintType[] constraints = webApp.getSecurityConstraintArray();
        for (int i = 0; i < constraints.length; ++i) {
            WebResourceCollectionType[] collections = constraints[i].getWebResourceCollectionArray();
            for (int j = 0; j < collections.length; ++j) {
                UrlPatternType[] patterns = collections[j].getUrlPatternArray();
                for (int k = 0; k < patterns.length; ++k) {
                    TomcatModuleBuilder.checkString(patterns[k].getStringValue());
                }
            }
        }
    }

    private static URI[] getFinalWebClasspath(WebModule webModule) throws Exception {
        URI[] oldClassPath = webModule.getWebClasspath();
        String target = webModule.getTargetPath();
        URI[] cleanClassPath = new URI[oldClassPath.length];
        for (int i = 0; i < oldClassPath.length; ++i) {
            String uri = oldClassPath[i].toString();
            cleanClassPath[i] = uri.startsWith(target) ? new URI(uri.substring(target.length() + 1)) : oldClassPath[i];
        }
        return cleanClassPath;
    }

    private static void checkString(String pattern) throws DeploymentException {
        if (pattern.indexOf(13) >= 0) {
            throw new DeploymentException("<url-pattern> must not contain CR(#xD)");
        }
        if (pattern.indexOf(10) >= 0) {
            throw new DeploymentException("<url-pattern> must not contain LF(#xA)");
        }
    }

    private static void checkMultiplicities(WebAppType webApp) throws DeploymentException {
        if (webApp.getSessionConfigArray().length > 1) {
            throw new DeploymentException("Multiple <session-config> elements found");
        }
        if (webApp.getJspConfigArray().length > 1) {
            throw new DeploymentException("Multiple <jsp-config> elements found");
        }
        if (webApp.getLoginConfigArray().length > 1) {
            throw new DeploymentException("Multiple <login-config> elements found");
        }
    }

    public StoredObject configurePOJO(JarFile moduleFile, Object portInfoObject, String seiClassName, ClassLoader classLoader) throws DeploymentException, IOException {
        PortInfo portInfo = (PortInfo)portInfoObject;
        ServiceInfo serviceInfo = AxisServiceBuilder.createServiceInfo((PortInfo)portInfo, (ClassLoader)classLoader);
        JavaServiceDesc serviceDesc = serviceInfo.getServiceDesc();
        try {
            classLoader.loadClass(seiClassName);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Unable to load servlet class for pojo webservice: " + seiClassName, (Throwable)e);
        }
        POJOProvider provider = new POJOProvider();
        SOAPService service = new SOAPService(null, (Handler)provider, null);
        service.setServiceDescription((ServiceDesc)serviceDesc);
        service.setOption("className", (Object)seiClassName);
        HandlerInfoChainFactory handlerInfoChainFactory = new HandlerInfoChainFactory(serviceInfo.getHandlerInfos());
        service.setOption("handlerInfoChain", (Object)handlerInfoChainFactory);
        URI location = null;
        try {
            location = new URI(serviceDesc.getEndpointURL());
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Invalid webservice endpoint URI", (Throwable)e);
        }
        URI wsdlURI = null;
        try {
            wsdlURI = new URI(serviceDesc.getWSDLFile());
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Invalid wsdl URI", (Throwable)e);
        }
        classLoader = new ClassLoaderReference(classLoader);
        AxisWebServiceContainer axisWebServiceContainer = new AxisWebServiceContainer(location, wsdlURI, service, serviceInfo.getWsdlMap(), classLoader);
        return new StoredObject((Serializable)axisWebServiceContainer);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !TomcatModuleBuilder.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)TomcatModuleBuilder.class);
        GBeanInfoBuilder infoBuilder = new GBeanInfoBuilder(TomcatModuleBuilder.class, "ModuleBuilder");
        infoBuilder.addAttribute("defaultParentId", URI.class, true);
        infoBuilder.addAttribute("tomcatContainerObjectName", ObjectName.class, true);
        infoBuilder.addReference("WebServiceBuilder", WebServiceBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("Repository", Repository.class, "GBean");
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addInterface(ModuleBuilder.class);
        infoBuilder.setConstructor(new String[]{"defaultParentId", "tomcatContainerObjectName", "WebServiceBuilder", "Repository", "kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    class UncheckedItem {
        static final int NA = 0;
        static final int INTEGRAL = 1;
        static final int CONFIDENTIAL = 2;
        private int transportType = 0;
        private String name;

        public UncheckedItem(String name, String actions) {
            this.setName(name);
            this.setTransportType(actions);
        }

        public boolean equals(Object o) {
            UncheckedItem item = (UncheckedItem)o;
            return item.getKey().equals(this.getKey());
        }

        public String getKey() {
            return this.name + this.transportType;
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getTransportType() {
            return this.transportType;
        }

        public void setTransportType(String actions) {
            String[] tokens = actions.split(":", 2);
            if (tokens.length == 2) {
                if (tokens[1].equals("INTEGRAL")) {
                    this.transportType = 1;
                } else if (tokens[1].equals("CONFIDENTIAL")) {
                    this.transportType = 2;
                }
            }
        }
    }
}

