/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.remoting.jmx;

import java.io.IOException;
import java.io.Serializable;
import org.activeio.Packet;
import org.activeio.RequestListener;
import org.activeio.packet.EmptyPacket;
import org.apache.geronimo.core.service.Interceptor;
import org.apache.geronimo.core.service.Invocation;
import org.apache.geronimo.core.service.InvocationResult;
import org.apache.geronimo.security.remoting.jmx.RequestChannelInterceptor;

public class RequestChannelInterceptorInvoker
implements RequestListener {
    private ClassLoader classloader;
    private Interceptor next;

    public RequestChannelInterceptorInvoker(Interceptor next, ClassLoader classloader) {
        this.next = next;
        this.classloader = classloader;
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet onRequest(Packet request) {
        Thread currentThread = Thread.currentThread();
        ClassLoader orig = currentThread.getContextClassLoader();
        try {
            Invocation marshalledInvocation;
            try {
                currentThread.setContextClassLoader(this.classloader);
                marshalledInvocation = (Invocation)RequestChannelInterceptor.deserialize(request, this.classloader);
            }
            catch (Throwable e) {
                e.printStackTrace();
                Packet packet = RequestChannelInterceptor.serialize(new ThrowableWrapper(e));
                currentThread.setContextClassLoader(orig);
                return packet;
            }
            InvocationResult rc = this.next.invoke(marshalledInvocation);
            Packet packet = RequestChannelInterceptor.serialize(rc);
            return packet;
        }
        catch (IOException e) {
            EmptyPacket emptyPacket = EmptyPacket.EMPTY_PACKET;
            return emptyPacket;
        }
        finally {
            currentThread.setContextClassLoader(orig);
        }
    }

    public void onRquestError(IOException error) {
        System.out.println("Request Error:" + error);
    }

    public static class ThrowableWrapper
    implements Serializable {
        private static final long serialVersionUID = 3905243428970182455L;
        public Throwable exception;

        ThrowableWrapper(Throwable exception) {
            this.exception = exception;
        }
    }
}

