/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.remoting.jmx;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import javax.management.ObjectName;
import org.activeio.AcceptListener;
import org.activeio.AsyncChannel;
import org.activeio.AsyncChannelServer;
import org.activeio.Channel;
import org.activeio.Packet;
import org.activeio.RequestChannel;
import org.activeio.RequestListener;
import org.activeio.SyncChannel;
import org.activeio.SyncChannelServer;
import org.activeio.adapter.AsyncChannelToServerRequestChannel;
import org.activeio.adapter.AsyncToSyncChannel;
import org.activeio.adapter.SyncToAsyncChannel;
import org.activeio.adapter.SyncToAsyncChannelServer;
import org.activeio.filter.PacketAggregatingAsyncChannel;
import org.activeio.net.SocketMetadata;
import org.activeio.net.SocketSyncChannelFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.core.service.Interceptor;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.ObjectNameUtil;
import org.apache.geronimo.management.geronimo.NetworkConnector;
import org.apache.geronimo.proxy.ReflexiveInterceptor;
import org.apache.geronimo.security.jaas.server.JaasLoginServiceMBean;
import org.apache.geronimo.security.remoting.jmx.RequestChannelInterceptorInvoker;

public class JaasLoginServiceRemotingServer
implements GBeanLifecycle,
NetworkConnector {
    public static final ObjectName REQUIRED_OBJECT_NAME = ObjectNameUtil.getObjectName((String)"geronimo.remoting:target=JaasLoginServiceRemotingServer");
    private static final Log log = LogFactory.getLog((Class)JaasLoginServiceRemotingServer.class);
    private AsyncChannelServer server;
    private JaasLoginServiceMBean loginService;
    private String protocol;
    private String host;
    private int port;
    public static final GBeanInfo GBEAN_INFO;
    static /* synthetic */ Class class$org$activeio$net$SocketMetadata;

    public JaasLoginServiceRemotingServer(String protocol, String host, int port, JaasLoginServiceMBean loginService) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.loginService = loginService;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public URI getClientConnectURI() {
        return this.server.getConnectURI();
    }

    public InetSocketAddress getListenAddress() {
        if (this.server != null) {
            URI uri = this.server.getBindURI();
            return new InetSocketAddress(uri.getHost(), uri.getPort());
        }
        return new InetSocketAddress(this.host, this.port);
    }

    public void doStart() throws Exception {
        final ReflexiveInterceptor loginServiceInterceptor = new ReflexiveInterceptor((Object)this.loginService);
        this.server = this.createAsyncChannelServer();
        this.server.setAcceptListener(new AcceptListener(){

            public void onAccept(Channel channel) {
                RequestChannel requestChannel = null;
                try {
                    SyncChannel syncChannel = AsyncToSyncChannel.adapt((Channel)channel);
                    SocketMetadata socket = (SocketMetadata)syncChannel.narrow(class$org$activeio$net$SocketMetadata == null ? (class$org$activeio$net$SocketMetadata = JaasLoginServiceRemotingServer.class$("org.activeio.net.SocketMetadata")) : class$org$activeio$net$SocketMetadata);
                    socket.setTcpNoDelay(true);
                    requestChannel = JaasLoginServiceRemotingServer.this.createRequestChannel(syncChannel);
                    RequestChannelInterceptorInvoker invoker = new RequestChannelInterceptorInvoker((Interceptor)loginServiceInterceptor, JaasLoginServiceRemotingServer.this.loginService.getClass().getClassLoader());
                    requestChannel.setRequestListener((RequestListener)invoker);
                    requestChannel.start();
                }
                catch (IOException e) {
                    log.warn((Object)"Failed to accept connection.", (Throwable)e);
                    if (requestChannel != null) {
                        requestChannel.dispose();
                    }
                    channel.dispose();
                }
            }

            public void onAcceptError(IOException error) {
                log.warn((Object)("Accept Failed: " + error));
            }
        });
        this.server.start();
        log.debug((Object)("Remote login service started on: " + this.server.getConnectURI() + " clients can connect to: " + this.server.getConnectURI()));
    }

    private AsyncChannelServer createAsyncChannelServer() throws IOException, URISyntaxException {
        SocketSyncChannelFactory factory = new SocketSyncChannelFactory();
        SyncChannelServer server = factory.bindSyncChannel(new URI(this.protocol, null, this.host, this.port, null, null, null));
        return new SyncToAsyncChannelServer(server);
    }

    private RequestChannel createRequestChannel(SyncChannel channel) throws IOException {
        return new AsyncChannelToServerRequestChannel((AsyncChannel)new PacketAggregatingAsyncChannel(SyncToAsyncChannel.adapt((Channel)channel))){

            public void onPacket(Packet packet) {
                super.onPacket(packet);
                this.dispose();
            }
        };
    }

    public void doStop() {
        this.server.dispose();
        this.server = null;
        log.debug((Object)"Stopped remote login service.");
    }

    public void doFail() {
        if (this.server != null) {
            this.server.dispose();
            this.server = null;
        }
        log.warn((Object)"Failed remote login service.");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Remote Login Listener", (Class)JaasLoginServiceRemotingServer.class);
        infoFactory.addAttribute("clientConnectURI", URI.class, false);
        infoFactory.addReference("LoginService", JaasLoginServiceMBean.class, "JaasLoginService");
        infoFactory.addInterface(NetworkConnector.class, new String[]{"host", "port", "protocol"}, new String[]{"host", "port"});
        infoFactory.setConstructor(new String[]{"protocol", "host", "port", "LoginService"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

