/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.security.jaas.LoginModuleControlFlag;
import org.apache.geronimo.security.jaas.LoginUtils;
import org.apache.geronimo.security.jaas.client.ClientLoginModuleProxy;
import org.apache.geronimo.security.jaas.client.LoginModuleProxy;
import org.apache.geronimo.security.jaas.client.ServerLoginProxy;
import org.apache.geronimo.security.jaas.client.WrappingClientLoginModuleProxy;
import org.apache.geronimo.security.jaas.server.JaasLoginModuleConfiguration;
import org.apache.geronimo.security.jaas.server.JaasLoginServiceMBean;
import org.apache.geronimo.security.jaas.server.JaasSessionId;
import org.apache.geronimo.security.remoting.jmx.JaasLoginServiceRemotingClient;

public class JaasLoginCoordinator
implements LoginModule {
    public static final String OPTION_HOST = "host";
    public static final String OPTION_PORT = "port";
    public static final String OPTION_KERNEL = "kernel";
    public static final String OPTION_REALM = "realm";
    public static final String OPTION_SERVICENAME = "serviceName";
    public static final String OPTION_SERVICE_INSTANCE = "serviceInstance";
    private String serverHost;
    private int serverPort;
    private String realmName;
    private String kernelName;
    private ObjectName serviceName;
    private JaasLoginServiceMBean service;
    private CallbackHandler handler;
    private Subject subject;
    private JaasSessionId sessionHandle;
    private LoginModuleProxy[] proxies;
    private final Map sharedState = new HashMap();
    static /* synthetic */ Class class$org$apache$geronimo$security$jaas$client$JaasLoginCoordinator;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.serverHost = (String)options.get(OPTION_HOST);
        Object port = options.get(OPTION_PORT);
        if (port != null) {
            this.serverPort = Integer.parseInt((String)port);
        }
        this.realmName = (String)options.get(OPTION_REALM);
        this.kernelName = (String)options.get(OPTION_KERNEL);
        try {
            String s = (String)options.get(OPTION_SERVICENAME);
            this.serviceName = s != null ? new ObjectName(s) : null;
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("option serviceNameis not a valid ObjectName: " + options.get(OPTION_SERVICENAME));
        }
        this.service = port != null || this.kernelName != null ? this.connect() : (JaasLoginServiceMBean)options.get(OPTION_SERVICE_INSTANCE);
        this.handler = callbackHandler;
        this.subject = subject == null ? new Subject() : subject;
    }

    public boolean login() throws LoginException {
        this.sessionHandle = this.service.connectToRealm(this.realmName);
        JaasLoginModuleConfiguration[] config = this.service.getLoginConfiguration(this.sessionHandle);
        this.proxies = new LoginModuleProxy[config.length];
        for (int i = 0; i < this.proxies.length; ++i) {
            if (config[i].isServerSide()) {
                this.proxies[i] = new ServerLoginProxy(config[i].getFlag(), this.subject, i, this.service, this.sessionHandle);
            } else {
                LoginModule source = config[i].getLoginModule((class$org$apache$geronimo$security$jaas$client$JaasLoginCoordinator == null ? JaasLoginCoordinator.class$("org.apache.geronimo.security.jaas.client.JaasLoginCoordinator") : class$org$apache$geronimo$security$jaas$client$JaasLoginCoordinator).getClassLoader());
                this.proxies[i] = config[i].isWrapPrincipals() ? new WrappingClientLoginModuleProxy(config[i].getFlag(), this.subject, source, config[i].getLoginDomainName(), this.realmName) : new ClientLoginModuleProxy(config[i].getFlag(), this.subject, source);
            }
            this.proxies[i].initialize(this.subject, this.handler, this.sharedState, config[i].getOptions());
            this.syncSharedState();
        }
        return this.performLogin();
    }

    public boolean commit() throws LoginException {
        for (int i = 0; i < this.proxies.length; ++i) {
            this.proxies[i].commit();
            this.syncSharedState();
            this.syncPrincipals();
        }
        this.subject.getPrincipals().add(this.service.loginSucceeded(this.sessionHandle));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean abort() throws LoginException {
        try {
            for (int i = 0; i < this.proxies.length; ++i) {
                this.proxies[i].abort();
                this.syncSharedState();
            }
        }
        finally {
            this.service.loginFailed(this.sessionHandle);
        }
        this.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logout() throws LoginException {
        try {
            for (int i = 0; i < this.proxies.length; ++i) {
                this.proxies[i].logout();
                this.syncSharedState();
            }
        }
        finally {
            this.service.logout(this.sessionHandle);
        }
        this.clear();
        return true;
    }

    private void clear() {
        this.service = null;
        this.serverHost = null;
        this.serverPort = 0;
        this.realmName = null;
        this.kernelName = null;
        this.service = null;
        this.handler = null;
        this.subject = null;
        this.sessionHandle = null;
        this.proxies = null;
    }

    private JaasLoginServiceMBean connect() {
        if (this.serverHost != null && this.serverPort > 0) {
            return JaasLoginServiceRemotingClient.create(this.serverHost, this.serverPort);
        }
        Kernel kernel = KernelRegistry.getKernel((String)this.kernelName);
        try {
            return (JaasLoginServiceMBean)kernel.getGBean(this.serviceName);
        }
        catch (GBeanNotFoundException e) {
            IllegalStateException illegalStateException = new IllegalStateException();
            illegalStateException.initCause(e);
            throw illegalStateException;
        }
    }

    private boolean performLogin() throws LoginException {
        Boolean success = null;
        Boolean backup = null;
        for (int i = 0; i < this.proxies.length; ++i) {
            LoginModuleProxy proxy = this.proxies[i];
            boolean result = proxy.login();
            this.syncSharedState();
            if (proxy.getControlFlag() == LoginModuleControlFlag.REQUIRED) {
                if (success != null && !success.booleanValue()) continue;
                success = result ? Boolean.TRUE : Boolean.FALSE;
                continue;
            }
            if (proxy.getControlFlag() == LoginModuleControlFlag.REQUISITE) {
                if (!result) {
                    return false;
                }
                if (success != null) continue;
                success = Boolean.TRUE;
                continue;
            }
            if (proxy.getControlFlag() == LoginModuleControlFlag.SUFFICIENT) {
                if (!result || success != null && !success.booleanValue()) continue;
                return true;
            }
            if (proxy.getControlFlag() != LoginModuleControlFlag.OPTIONAL || backup != null && !backup.booleanValue()) continue;
            backup = result ? Boolean.TRUE : Boolean.FALSE;
        }
        if (success != null) {
            return success;
        }
        if (backup != null) {
            return backup;
        }
        return false;
    }

    private void syncSharedState() throws LoginException {
        Map map = this.service.syncShareState(this.sessionHandle, LoginUtils.getSerializableCopy(this.sharedState));
        this.sharedState.putAll(map);
    }

    private void syncPrincipals() throws LoginException {
        Set principals = this.service.syncPrincipals(this.sessionHandle, this.subject.getPrincipals());
        this.subject.getPrincipals().addAll(principals);
    }
}

