/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.util;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.security.PrimaryRealmPrincipal;
import org.apache.geronimo.security.RealmPrincipal;
import org.apache.geronimo.security.deploy.DefaultPrincipal;

public class ConfigurationUtil {
    static /* synthetic */ Class class$java$lang$String;

    public static X500Principal generateX500Principal(String name) {
        return new X500Principal(name);
    }

    public static RealmPrincipal generateRealmPrincipal(org.apache.geronimo.security.deploy.Principal principal, String loginDomain) {
        return ConfigurationUtil.generateRealmPrincipal(principal.getClassName(), principal.getPrincipalName(), loginDomain);
    }

    public static RealmPrincipal generateRealmPrincipal(final String className, final String principalName, final String loginDomain) {
        try {
            return (RealmPrincipal)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Principal p = null;
                    Class<?> clazz = Class.forName(className);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = ConfigurationUtil.class$("java.lang.String")) : class$java$lang$String);
                    p = (Principal)constructor.newInstance(principalName);
                    return new RealmPrincipal(loginDomain, p);
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
            if (e.getException() != null) {
                e.getException().printStackTrace();
            }
            return null;
        }
    }

    public static PrimaryRealmPrincipal generatePrimaryRealmPrincipal(org.apache.geronimo.security.deploy.Principal principal, String loginDomain) {
        return ConfigurationUtil.generatePrimaryRealmPrincipal(principal.getClassName(), principal.getPrincipalName(), loginDomain);
    }

    public static PrimaryRealmPrincipal generatePrimaryRealmPrincipal(final String className, final String principalName, final String loginDomain) {
        try {
            return (PrimaryRealmPrincipal)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Principal p = null;
                    Class<?> clazz = Class.forName(className);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = ConfigurationUtil.class$("java.lang.String")) : class$java$lang$String);
                    p = (Principal)constructor.newInstance(principalName);
                    return new PrimaryRealmPrincipal(loginDomain, p);
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
            if (e.getException() != null) {
                e.getException().printStackTrace();
            }
            return null;
        }
    }

    public static Subject generateDefaultSubject(DefaultPrincipal defaultPrincipal) throws GeronimoSecurityException {
        if (defaultPrincipal == null) {
            throw new GeronimoSecurityException("No DefaultPrincipal configuration supplied");
        }
        Subject defaultSubject = new Subject();
        RealmPrincipal realmPrincipal = ConfigurationUtil.generateRealmPrincipal(defaultPrincipal.getPrincipal(), defaultPrincipal.getRealmName());
        if (realmPrincipal == null) {
            throw new GeronimoSecurityException("Unable to create realm principal");
        }
        PrimaryRealmPrincipal primaryRealmPrincipal = ConfigurationUtil.generatePrimaryRealmPrincipal(defaultPrincipal.getPrincipal(), defaultPrincipal.getRealmName());
        if (primaryRealmPrincipal == null) {
            throw new GeronimoSecurityException("Unable to create primary realm principal");
        }
        defaultSubject.getPrincipals().add(realmPrincipal);
        defaultSubject.getPrincipals().add(primaryRealmPrincipal);
        Set namedUserPasswordCredentials = defaultPrincipal.getNamedUserPasswordCredentials();
        if (namedUserPasswordCredentials != null) {
            defaultSubject.getPrivateCredentials().addAll(namedUserPasswordCredentials);
        }
        return defaultSubject;
    }

    public static void registerPolicyContextHandler(PolicyContextHandler handler, boolean replace) throws PolicyContextException {
        String[] keys = handler.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            PolicyContext.registerHandler((String)keys[i], (PolicyContextHandler)handler, (boolean)replace);
        }
    }
}

