/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.remoting.jmx;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.activeio.Packet;
import org.activeio.RequestChannel;
import org.activeio.SynchChannel;
import org.activeio.adapter.AsynchChannelToClientRequestChannel;
import org.activeio.adapter.PacketInputStream;
import org.activeio.filter.PacketAggregatingSynchChannel;
import org.activeio.net.SocketMetadata;
import org.activeio.net.SocketSynchChannelFactory;
import org.activeio.packet.ByteArrayPacket;
import org.apache.geronimo.core.service.Interceptor;
import org.apache.geronimo.core.service.Invocation;
import org.apache.geronimo.core.service.InvocationResult;
import org.apache.geronimo.kernel.ObjectInputStreamExt;
import org.apache.geronimo.security.remoting.jmx.RequestChannelInterceptorInvoker;

public class RequestChannelInterceptor
implements Interceptor {
    private final ClassLoader cl;
    private final URI target;

    public RequestChannelInterceptor(URI target, ClassLoader cl) {
        this.target = target;
        this.cl = cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocationResult invoke(Invocation invocation) throws Throwable {
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object obj;
            Packet response;
            RequestChannel channel = RequestChannelInterceptor.createRequestChannel(this.target);
            try {
                channel.start();
                Packet request = RequestChannelInterceptor.serialize(invocation);
                response = channel.request(request, -1L);
            }
            finally {
                channel.dispose();
            }
            try {
                obj = RequestChannelInterceptor.deserialize(response, this.cl);
            }
            catch (ClassNotFoundException e) {
                Thread.currentThread().setContextClassLoader(RequestChannelInterceptor.class.getClassLoader());
                response.clear();
                obj = RequestChannelInterceptor.deserialize(response, this.cl);
            }
            if (obj instanceof RequestChannelInterceptorInvoker.ThrowableWrapper) {
                throw ((RequestChannelInterceptorInvoker.ThrowableWrapper)obj).exception;
            }
            InvocationResult invocationResult = (InvocationResult)obj;
            return invocationResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }

    private static RequestChannel createRequestChannel(URI target) throws IOException, URISyntaxException {
        SocketSynchChannelFactory factory = new SocketSynchChannelFactory();
        SynchChannel channel = factory.openSynchChannel(target);
        SocketMetadata socket = (SocketMetadata)channel.narrow(SocketMetadata.class);
        socket.setTcpNoDelay(true);
        return new AsynchChannelToClientRequestChannel((SynchChannel)new PacketAggregatingSynchChannel(channel));
    }

    public static Object deserialize(Packet response, ClassLoader cl) throws IOException, ClassNotFoundException {
        ObjectInputStreamExt is = new ObjectInputStreamExt((InputStream)new PacketInputStream(response), cl);
        Object rc = is.readObject();
        is.close();
        return rc;
    }

    public static Packet serialize(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        return new ByteArrayPacket(baos.toByteArray());
    }
}

