/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.remoting.jmx;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.management.ObjectName;
import org.activeio.AcceptListener;
import org.activeio.AsynchChannel;
import org.activeio.AsynchChannelServer;
import org.activeio.Channel;
import org.activeio.Packet;
import org.activeio.RequestChannel;
import org.activeio.RequestListener;
import org.activeio.SynchChannel;
import org.activeio.SynchChannelServer;
import org.activeio.adapter.AsynchChannelToServerRequestChannel;
import org.activeio.adapter.AsynchToSynchChannelAdapter;
import org.activeio.adapter.SynchToAsynchChannelAdapter;
import org.activeio.adapter.SynchToAsynchChannelServerAdapter;
import org.activeio.filter.PacketAggregatingAsynchChannel;
import org.activeio.net.SocketMetadata;
import org.activeio.net.SocketSynchChannelFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.core.service.Interceptor;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.proxy.ReflexiveInterceptor;
import org.apache.geronimo.security.jaas.JaasLoginServiceMBean;
import org.apache.geronimo.security.remoting.jmx.RequestChannelInterceptorInvoker;

public class JaasLoginServiceRemotingServer
implements GBeanLifecycle {
    public static final ObjectName REQUIRED_OBJECT_NAME = JMXUtil.getObjectName((String)"geronimo.remoting:target=JaasLoginServiceRemotingServer");
    private static final Log log = LogFactory.getLog((Class)JaasLoginServiceRemotingServer.class);
    private AsynchChannelServer server;
    private JaasLoginServiceMBean loginService;
    private final URI bindURI;
    public static final GBeanInfo GBEAN_INFO;
    static /* synthetic */ Class class$org$activeio$net$SocketMetadata;

    public JaasLoginServiceRemotingServer(URI bindURI, JaasLoginServiceMBean loginService) {
        this.bindURI = bindURI;
        this.loginService = loginService;
    }

    public URI getClientConnectURI() {
        return this.server.getConnectURI();
    }

    public void doStart() throws Exception {
        final ReflexiveInterceptor loginServiceInterceptor = new ReflexiveInterceptor((Object)this.loginService);
        this.server = this.createAsynchChannelServer();
        this.server.setAcceptListener(new AcceptListener(){

            public void onAccept(Channel channel) {
                RequestChannel requestChannel = null;
                try {
                    SynchChannel synchChannel = AsynchToSynchChannelAdapter.adapt((Channel)channel);
                    SocketMetadata socket = (SocketMetadata)synchChannel.narrow(class$org$activeio$net$SocketMetadata == null ? (class$org$activeio$net$SocketMetadata = JaasLoginServiceRemotingServer.class$("org.activeio.net.SocketMetadata")) : class$org$activeio$net$SocketMetadata);
                    socket.setTcpNoDelay(true);
                    requestChannel = JaasLoginServiceRemotingServer.this.createRequestChannel(synchChannel);
                    RequestChannelInterceptorInvoker invoker = new RequestChannelInterceptorInvoker((Interceptor)loginServiceInterceptor, JaasLoginServiceRemotingServer.this.loginService.getClass().getClassLoader());
                    requestChannel.setRequestListener((RequestListener)invoker);
                    requestChannel.start();
                }
                catch (IOException e) {
                    log.info((Object)"Failed to accept connection.", (Throwable)e);
                    if (requestChannel != null) {
                        requestChannel.dispose();
                    }
                    channel.dispose();
                }
            }

            public void onAcceptError(IOException error) {
                log.info((Object)("Accept Failed: " + error));
            }
        });
        this.server.start();
        log.info((Object)("Remote login service started on: " + this.server.getConnectURI() + " clients can connect to: " + this.server.getConnectURI()));
    }

    private AsynchChannelServer createAsynchChannelServer() throws IOException, URISyntaxException {
        SocketSynchChannelFactory factory = new SocketSynchChannelFactory();
        SynchChannelServer server = factory.bindSynchChannel(this.bindURI);
        return new SynchToAsynchChannelServerAdapter(server);
    }

    private RequestChannel createRequestChannel(SynchChannel channel) throws IOException {
        return new AsynchChannelToServerRequestChannel((AsynchChannel)new PacketAggregatingAsynchChannel(SynchToAsynchChannelAdapter.adapt((Channel)channel))){

            public void onPacket(Packet packet) {
                super.onPacket(packet);
                this.dispose();
            }
        };
    }

    public void doStop() {
        this.server.dispose();
        this.server = null;
        log.info((Object)"Stopped remote login service.");
    }

    public void doFail() {
        if (this.server != null) {
            this.server.dispose();
            this.server = null;
        }
        log.info((Object)"Failed remote login service.");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(JaasLoginServiceRemotingServer.class);
        infoFactory.addAttribute("bindURI", URI.class, true);
        infoFactory.addAttribute("clientConnectURI", URI.class, false);
        infoFactory.addReference("LoginService", JaasLoginServiceMBean.class, "GBean");
        infoFactory.setConstructor(new String[]{"bindURI", "LoginService"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

