/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.security.realm.providers.CertificateCallback;
import org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal;
import org.apache.geronimo.security.realm.providers.GeronimoUserPrincipal;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class CertificatePropertiesFileLoginModule
implements LoginModule {
    public static final String USERS_URI = "usersURI";
    public static final String GROUPS_URI = "groupsURI";
    private static Log log;
    private final Map users = new HashMap();
    final Map groups = new HashMap();
    Subject subject;
    CallbackHandler handler;
    X500Principal principal;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = callbackHandler;
        try {
            Kernel kernel = KernelRegistry.getKernel((String)((String)options.get("org.apache.geronimo.security.realm.GenericSecurityRealm.KERNEL")));
            ServerInfo serverInfo = (ServerInfo)options.get("org.apache.geronimo.security.realm.GenericSecurityRealm.SERVERINFO");
            URI usersURI = new URI((String)options.get(USERS_URI));
            URI groupsURI = new URI((String)options.get(GROUPS_URI));
            this.loadProperties(kernel, serverInfo, usersURI, groupsURI);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IllegalArgumentException("Unable to configure properties file login module: " + e);
        }
    }

    public void loadProperties(Kernel kernel, ServerInfo serverInfo, URI usersURI, URI groupURI) throws GeronimoSecurityException {
        try {
            URI userFile = serverInfo.resolve(usersURI);
            URI groupFile = serverInfo.resolve(groupURI);
            InputStream stream = userFile.toURL().openStream();
            Properties tmpUsers = new Properties();
            tmpUsers.load(stream);
            stream.close();
            Iterator<Map.Entry<Object, Object>> iterator = tmpUsers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                this.users.put(entry.getValue(), entry.getKey());
            }
            Properties temp = new Properties();
            stream = groupFile.toURL().openStream();
            temp.load(stream);
            stream.close();
            Enumeration<Object> e = temp.keys();
            while (e.hasMoreElements()) {
                String groupName = (String)e.nextElement();
                String[] userList = ((String)temp.get(groupName)).split(",");
                HashSet<String> userset = (HashSet<String>)this.groups.get(groupName);
                if (userset == null) {
                    userset = new HashSet<String>();
                    this.groups.put(groupName, userset);
                }
                for (int i = 0; i < userList.length; ++i) {
                    String userName = userList[i];
                    userset.add(userName);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Properties File Login Module - data load failed", (Throwable)e);
            throw new GeronimoSecurityException((Throwable)e);
        }
    }

    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new CertificateCallback()};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        if (!$assertionsDisabled && callbacks.length != 1) {
            throw new AssertionError();
        }
        X509Certificate certificate = ((CertificateCallback)callbacks[0]).getCertificate();
        if (certificate == null) {
            return false;
        }
        this.principal = certificate.getSubjectX500Principal();
        return this.users.containsKey(this.principal.getName());
    }

    public boolean commit() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals();
        principals.add(this.principal);
        String userName = (String)this.users.get(this.principal.getName());
        principals.add(new GeronimoUserPrincipal(userName));
        Iterator e = this.groups.keySet().iterator();
        block0: while (e.hasNext()) {
            String groupName = (String)e.next();
            Set users = (Set)this.groups.get(groupName);
            Iterator iter = users.iterator();
            while (iter.hasNext()) {
                String user = (String)iter.next();
                if (!userName.equals(user)) continue;
                principals.add(new GeronimoGroupPrincipal(groupName));
                continue block0;
            }
        }
        return true;
    }

    public boolean abort() throws LoginException {
        this.principal = null;
        return true;
    }

    public boolean logout() throws LoginException {
        this.principal = null;
        return true;
    }

    public String[] getPrincipalClassNames() {
        return new String[]{GeronimoUserPrincipal.class.getName(), GeronimoGroupPrincipal.class.getName()};
    }

    /*
     * WARNING - void declaration
     */
    public String[] getPrincipalsOfClass(String className) {
        void var2_2;
        Collection<Object> s;
        if (className.equals(GeronimoGroupPrincipal.class.getName())) {
            s = this.groups.keySet();
        } else if (className.equals(GeronimoUserPrincipal.class.getName())) {
            s = this.users.values();
        } else if (className.equals(X500Principal.class.getName())) {
            s = this.users.keySet();
        } else {
            throw new IllegalArgumentException("No such principal class " + className);
        }
        return var2_2.toArray(new String[var2_2.size()]);
    }

    static {
        $assertionsDisabled = !CertificatePropertiesFileLoginModule.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)CertificatePropertiesFileLoginModule.class);
    }
}

