/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.security.realm.providers.CertificateChainCallback;
import org.apache.geronimo.security.realm.providers.GeronimoUserPrincipal;

public class CertificateChainLoginModule
implements LoginModule {
    private static Log log;
    Subject subject;
    CallbackHandler handler;
    X500Principal principal;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = callbackHandler;
    }

    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new CertificateChainCallback()};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        if (!$assertionsDisabled && callbacks.length != 1) {
            throw new AssertionError();
        }
        Certificate[] certificateChain = ((CertificateChainCallback)callbacks[0]).getCertificateChain();
        if (certificateChain == null || certificateChain.length == 0) {
            return false;
        }
        if (!(certificateChain[0] instanceof X509Certificate)) {
            return false;
        }
        this.principal = ((X509Certificate)certificateChain[0]).getSubjectX500Principal();
        return true;
    }

    public boolean commit() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals();
        principals.add(this.principal);
        principals.add(new GeronimoUserPrincipal(this.principal.getName()));
        return true;
    }

    public boolean abort() throws LoginException {
        this.principal = null;
        return true;
    }

    public boolean logout() throws LoginException {
        this.principal = null;
        return true;
    }

    public String[] getPrincipalClassNames() {
        return new String[]{GeronimoUserPrincipal.class.getName()};
    }

    static {
        $assertionsDisabled = !CertificateChainLoginModule.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)CertificateChainLoginModule.class);
    }
}

