/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.util.Properties;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.security.jaas.ConfigurationEntryFactory;
import org.apache.geronimo.security.jaas.JaasLoginCoordinator;
import org.apache.geronimo.security.jaas.JaasLoginModuleConfiguration;
import org.apache.geronimo.security.jaas.LoginModuleControlFlag;

public class ServerRealmConfigurationEntry
implements ConfigurationEntryFactory {
    private final String applicationConfigName;
    private final String realmName;
    private final Kernel kernel;
    public static final GBeanInfo GBEAN_INFO;

    public ServerRealmConfigurationEntry() {
        this.applicationConfigName = null;
        this.realmName = null;
        this.kernel = null;
    }

    public ServerRealmConfigurationEntry(String applicationConfigName, String realmName, Kernel kernel) {
        this.applicationConfigName = applicationConfigName;
        this.realmName = realmName;
        if (applicationConfigName == null || realmName == null) {
            throw new IllegalArgumentException("applicationConfigName and realmName are required");
        }
        if (applicationConfigName.equals(realmName)) {
            throw new IllegalArgumentException("applicationConfigName must be different than realmName (there's an automatic entry using the same name as the realm name, so you don't need a ServerRealmConfigurationEntry if you're just going to use that!)");
        }
        this.kernel = kernel;
    }

    public String getConfigurationName() {
        return this.applicationConfigName;
    }

    public JaasLoginModuleConfiguration generateConfiguration() {
        Properties options = new Properties();
        options.put("realm", this.realmName);
        options.put("kernel", this.kernel.getKernelName());
        return new JaasLoginModuleConfiguration(JaasLoginCoordinator.class.getName(), LoginModuleControlFlag.REQUIRED, options, true, this.applicationConfigName);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(ServerRealmConfigurationEntry.class, "ConfigurationEntry");
        infoFactory.addInterface(ConfigurationEntryFactory.class);
        infoFactory.addAttribute("applicationConfigName", String.class, true);
        infoFactory.addAttribute("realmName", String.class, true);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.setConstructor(new String[]{"applicationConfigName", "realmName", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

