/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import javax.security.auth.login.LoginException;
import org.apache.geronimo.security.jaas.LoginModuleConfiguration;
import org.apache.geronimo.security.jaas.LoginModuleControlFlag;

public class LoginUtils {
    public static boolean computeLogin(LoginModuleConfiguration[] modules) throws LoginException {
        Boolean success = null;
        Boolean backup = null;
        for (int i = 0; i < modules.length; ++i) {
            LoginModuleConfiguration module = modules[i];
            boolean result = module.getModule().login();
            if (module.getControlFlag() == LoginModuleControlFlag.REQUIRED) {
                if (success != null && !success.booleanValue()) continue;
                success = result ? Boolean.TRUE : Boolean.FALSE;
                continue;
            }
            if (module.getControlFlag() == LoginModuleControlFlag.REQUISITE) {
                if (!result) {
                    return false;
                }
                if (success != null) continue;
                success = Boolean.TRUE;
                continue;
            }
            if (module.getControlFlag() == LoginModuleControlFlag.SUFFICIENT) {
                if (!result || success != null && !success.booleanValue()) continue;
                return true;
            }
            if (module.getControlFlag() != LoginModuleControlFlag.OPTIONAL || backup != null && !backup.booleanValue()) continue;
            backup = result ? Boolean.TRUE : Boolean.FALSE;
        }
        if (success != null) {
            return success;
        }
        if (backup != null) {
            return backup;
        }
        return false;
    }
}

