/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.RealmPrincipal;
import org.apache.geronimo.security.jaas.DecouplingCallbackHandler;
import org.apache.geronimo.security.jaas.JaasLoginModuleConfiguration;

public class JaasSecurityContext {
    private final String realmName;
    private final Subject subject;
    private final long created;
    private boolean done;
    private final JaasLoginModuleConfiguration[] modules;
    private final LoginModule[] loginModules;
    private DecouplingCallbackHandler handler;
    private final Set processedPrincipals = new HashSet();

    public JaasSecurityContext(String realmName, JaasLoginModuleConfiguration[] modules, ClassLoader classLoader) {
        this.realmName = realmName;
        this.created = System.currentTimeMillis();
        this.done = false;
        this.modules = modules;
        this.subject = new Subject();
        this.loginModules = new LoginModule[modules.length];
        for (int i = 0; i < modules.length; ++i) {
            this.loginModules[i] = modules[i].getLoginModule(classLoader);
        }
    }

    public Subject getSubject() {
        return this.subject;
    }

    public long getCreated() {
        return this.created;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public JaasLoginModuleConfiguration[] getModules() {
        return this.modules;
    }

    public LoginModule getLoginModule(int index) throws LoginException {
        this.checkRange(index);
        return this.loginModules[index];
    }

    private void checkRange(int index) throws LoginException {
        if (index < 0 || index >= this.loginModules.length) {
            throw new LoginException("Invalid index: " + index);
        }
    }

    public boolean isServerSide(int index) throws LoginException {
        this.checkRange(index);
        return this.modules[index].isServerSide();
    }

    public String getLoginDomainName(int index) throws LoginException {
        this.checkRange(index);
        return this.modules[index].getLoginDomainName();
    }

    public Map getOptions(int index) throws LoginException {
        this.checkRange(index);
        return this.modules[index].getOptions();
    }

    public DecouplingCallbackHandler getHandler() {
        if (this.handler == null) {
            this.handler = new DecouplingCallbackHandler();
        }
        return this.handler;
    }

    public void processPrincipals(String loginDomainName) {
        LinkedList<RealmPrincipal> list = new LinkedList<RealmPrincipal>();
        Iterator<Principal> it = this.subject.getPrincipals().iterator();
        while (it.hasNext()) {
            Principal p = it.next();
            if (p instanceof RealmPrincipal || this.processedPrincipals.contains(p)) continue;
            list.add(ContextManager.registerPrincipal(new RealmPrincipal(loginDomainName, p)));
            this.processedPrincipals.add(p);
        }
        this.subject.getPrincipals().addAll(list);
    }

    public void processPrincipals(Principal[] principals, String loginDomainName) {
        LinkedList<Principal> list = new LinkedList<Principal>();
        for (int i = 0; i < principals.length; ++i) {
            Principal p = principals[i];
            list.add(p);
            list.add(ContextManager.registerPrincipal(new RealmPrincipal(loginDomainName, p)));
            this.processedPrincipals.add(p);
        }
        this.subject.getPrincipals().addAll(list);
    }

    public Set getProcessedPrincipals() {
        return this.processedPrincipals;
    }

    public String getRealmName() {
        return this.realmName;
    }
}

