/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import [Ljava.security.Principal;;
import [Ljavax.security.auth.callback.Callback;;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.IdentificationPrincipal;
import org.apache.geronimo.security.SubjectId;
import org.apache.geronimo.security.jaas.ExpiredLoginModuleException;
import org.apache.geronimo.security.jaas.JaasClientId;
import org.apache.geronimo.security.jaas.JaasLoginModuleConfiguration;
import org.apache.geronimo.security.jaas.JaasLoginServiceMBean;
import org.apache.geronimo.security.jaas.JaasSecurityContext;
import org.apache.geronimo.security.realm.SecurityRealm;

public class JaasLoginService
implements GBeanLifecycle,
JaasLoginServiceMBean {
    public static final ObjectName OBJECT_NAME;
    public static final Log log;
    private static final int DEFAULT_EXPIRED_LOGIN_SCAN_INTERVAL = 300000;
    private static final int DEFAULT_MAX_LOGIN_DURATION = 86400000;
    private static final ClockDaemon clockDaemon;
    private static long nextLoginModuleId;
    private ReferenceCollection realms;
    private Object expiredLoginScanIdentifier;
    private final SecretKey key;
    private final String algorithm;
    private final ClassLoader classLoader;
    private final Map activeLogins = new Hashtable();
    private int expiredLoginScanIntervalMillis = 300000;
    private int maxLoginDurationMillis = 86400000;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JaasLoginService(String algorithm, String password, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.algorithm = algorithm;
        this.key = new SecretKeySpec(password.getBytes(), algorithm);
    }

    public Collection getRealms() throws GeronimoSecurityException {
        return this.realms;
    }

    public void setRealms(Collection realms) {
        this.realms = (ReferenceCollection)realms;
    }

    public int getMaxLoginDurationMillis() {
        return this.maxLoginDurationMillis;
    }

    public void setMaxLoginDurationMillis(int maxLoginDurationMillis) {
        if (maxLoginDurationMillis == 0) {
            maxLoginDurationMillis = 86400000;
        }
        this.maxLoginDurationMillis = maxLoginDurationMillis;
    }

    public int getExpiredLoginScanIntervalMillis() {
        return this.expiredLoginScanIntervalMillis;
    }

    public void setExpiredLoginScanIntervalMillis(int expiredLoginScanIntervalMillis) {
        if (expiredLoginScanIntervalMillis == 0) {
            expiredLoginScanIntervalMillis = 300000;
        }
        this.expiredLoginScanIntervalMillis = expiredLoginScanIntervalMillis;
    }

    public void doStart() throws Exception {
        this.expiredLoginScanIdentifier = clockDaemon.executePeriodically((long)this.expiredLoginScanIntervalMillis, (Runnable)new ExpirationMonitor(), true);
    }

    public void doStop() throws Exception {
        ClockDaemon.cancel((Object)this.expiredLoginScanIdentifier);
    }

    public void doFail() {
    }

    public JaasClientId connectToRealm(String realmName) {
        SecurityRealm realm = null;
        realm = this.getRealm(realmName);
        if (realm == null) {
            throw new GeronimoSecurityException("No such realm (" + realmName + ")");
        }
        return this.initializeClient(realm);
    }

    public JaasLoginModuleConfiguration[] getLoginConfiguration(JaasClientId userIdentifier) throws LoginException {
        JaasSecurityContext context = (JaasSecurityContext)this.activeLogins.get(userIdentifier);
        if (context == null) {
            throw new ExpiredLoginModuleException();
        }
        JaasLoginModuleConfiguration[] config = context.getModules();
        JaasLoginModuleConfiguration[] result = new JaasLoginModuleConfiguration[config.length];
        for (int i = 0; i < config.length; ++i) {
            result[i] = config[i].getSerializableCopy();
        }
        return result;
    }

    public Callback[] getServerLoginCallbacks(JaasClientId userIdentifier, int loginModuleIndex) throws LoginException {
        JaasSecurityContext context = (JaasSecurityContext)this.activeLogins.get(userIdentifier);
        this.checkContext(context, loginModuleIndex, true);
        LoginModule module = context.getLoginModule(loginModuleIndex);
        context.getHandler().setExploring();
        try {
            module.initialize(context.getSubject(), context.getHandler(), new HashMap(), context.getOptions(loginModuleIndex));
        }
        catch (Exception e) {
            System.err.println("Failed to initialize module");
            e.printStackTrace();
        }
        try {
            module.login();
        }
        catch (LoginException e) {
            // empty catch block
        }
        try {
            module.abort();
        }
        catch (LoginException e) {
            // empty catch block
        }
        return context.getHandler().finalizeCallbackList();
    }

    private void checkContext(JaasSecurityContext context, int loginModuleIndex, boolean expectServerSide) throws LoginException {
        if (context == null) {
            throw new ExpiredLoginModuleException();
        }
        if (loginModuleIndex < 0 || loginModuleIndex >= context.getModules().length || context.isServerSide(loginModuleIndex) != expectServerSide) {
            throw new LoginException("Invalid login module specified");
        }
    }

    public boolean performServerLogin(JaasClientId userIdentifier, int loginModuleIndex, Callback[] results) throws LoginException {
        JaasSecurityContext context = (JaasSecurityContext)this.activeLogins.get(userIdentifier);
        this.checkContext(context, loginModuleIndex, true);
        try {
            context.getHandler().setClientResponse(results);
        }
        catch (IllegalArgumentException iae) {
            throw new LoginException(iae.toString());
        }
        return context.getLoginModule(loginModuleIndex).login();
    }

    public void clientLoginModuleCommit(JaasClientId userIdentifier, int loginModuleIndex, Principal[] clientLoginModulePrincipals) throws LoginException {
        JaasSecurityContext context = (JaasSecurityContext)this.activeLogins.get(userIdentifier);
        this.checkContext(context, loginModuleIndex, false);
        context.processPrincipals(clientLoginModulePrincipals, context.getLoginDomainName(loginModuleIndex));
    }

    public boolean serverLoginModuleCommit(JaasClientId userIdentifier, int loginModuleIndex) throws LoginException {
        JaasSecurityContext context = (JaasSecurityContext)this.activeLogins.get(userIdentifier);
        this.checkContext(context, loginModuleIndex, true);
        boolean result = context.getLoginModule(loginModuleIndex).commit();
        context.processPrincipals(context.getLoginDomainName(loginModuleIndex));
        return result;
    }

    public Principal[] loginSucceeded(JaasClientId userIdentifier) throws LoginException {
        JaasSecurityContext context = (JaasSecurityContext)this.activeLogins.get(userIdentifier);
        if (context == null) {
            throw new ExpiredLoginModuleException();
        }
        Subject subject = context.getSubject();
        ContextManager.registerSubject(subject);
        SubjectId id = ContextManager.getSubjectId(subject);
        IdentificationPrincipal principal = new IdentificationPrincipal(id);
        subject.getPrincipals().add(principal);
        SecurityRealm realm = this.getRealm(context.getRealmName());
        if (realm.isRestrictPrincipalsToServer()) {
            return new Principal[]{principal};
        }
        ArrayList<IdentificationPrincipal> list = new ArrayList<IdentificationPrincipal>();
        list.addAll(context.getProcessedPrincipals());
        list.add(principal);
        return list.toArray(new Principal[list.size()]);
    }

    public void loginFailed(JaasClientId userIdentifier) {
        this.activeLogins.remove(userIdentifier);
    }

    public void logout(JaasClientId userIdentifier) throws LoginException {
        JaasSecurityContext context = (JaasSecurityContext)this.activeLogins.get(userIdentifier);
        if (context == null) {
            throw new ExpiredLoginModuleException();
        }
        ContextManager.unregisterSubject(context.getSubject());
        this.activeLogins.remove(userIdentifier);
        for (int i = 0; i < context.getModules().length; ++i) {
            if (!context.isServerSide(i)) continue;
            context.getLoginModule(i).logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JaasClientId initializeClient(SecurityRealm realm) {
        long id;
        Class clazz = JaasLoginService.class;
        synchronized (clazz) {
            id = ++nextLoginModuleId;
        }
        JaasClientId clientId = new JaasClientId(id, this.hash(id));
        JaasLoginModuleConfiguration[] modules = realm.getAppConfigurationEntries();
        JaasSecurityContext context = new JaasSecurityContext(realm.getRealmName(), modules, this.classLoader);
        this.activeLogins.put(clientId, context);
        return clientId;
    }

    private SecurityRealm getRealm(String realmName) {
        Iterator it = this.realms.iterator();
        while (it.hasNext()) {
            SecurityRealm test = (SecurityRealm)it.next();
            if (!test.getRealmName().equals(realmName)) continue;
            return test;
        }
        return null;
    }

    private byte[] hash(long id) {
        byte[] bytes = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bytes[i] = (byte)id;
            id >>>= 8;
        }
        try {
            Mac mac = Mac.getInstance(this.algorithm);
            mac.init(this.key);
            mac.update(bytes);
            return mac.doFinal();
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeyException e) {
            // empty catch block
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Should never have reached here");
        }
        return null;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !JaasLoginService.class.desiredAssertionStatus();
        OBJECT_NAME = JMXUtil.getObjectName((String)"geronimo.server:J2EEApplication=null,J2EEModule=org/apache/geronimo/Server,J2EEServer=geronimo,j2eeType=GBean,name=JaasLoginService");
        log = LogFactory.getLog((Class)JaasLoginService.class);
        nextLoginModuleId = System.currentTimeMillis();
        clockDaemon = new ClockDaemon();
        clockDaemon.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "LoginService login modules monitor");
                t.setDaemon(true);
                return t;
            }
        });
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(JaasLoginService.class);
        infoFactory.addAttribute("algorithm", String.class, true);
        infoFactory.addAttribute("password", String.class, true);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addAttribute("maxLoginDurationMillis", Integer.TYPE, true);
        infoFactory.addAttribute("expiredLoginScanIntervalMillis", Integer.TYPE, true);
        infoFactory.addOperation("connectToRealm", new Class[]{String.class});
        infoFactory.addOperation("getLoginConfiguration", new Class[]{JaasClientId.class});
        infoFactory.addOperation("getServerLoginCallbacks", new Class[]{JaasClientId.class, Integer.TYPE});
        infoFactory.addOperation("performServerLogin", new Class[]{JaasClientId.class, Integer.TYPE, Callback;.class});
        infoFactory.addOperation("clientLoginModuleCommit", new Class[]{JaasClientId.class, Integer.TYPE, Principal;.class});
        infoFactory.addOperation("serverLoginModuleCommit", new Class[]{JaasClientId.class, Integer.TYPE});
        infoFactory.addOperation("loginSucceeded", new Class[]{JaasClientId.class});
        infoFactory.addOperation("loginFailed", new Class[]{JaasClientId.class});
        infoFactory.addOperation("logout", new Class[]{JaasClientId.class});
        infoFactory.addReference("Realms", SecurityRealm.class, "SecurityRealm");
        infoFactory.setConstructor(new String[]{"algorithm", "password", "classLoader"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private class ExpirationMonitor
    implements Runnable {
        private ExpirationMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long now = System.currentTimeMillis();
            LinkedList<JaasSecurityContext> list = new LinkedList<JaasSecurityContext>();
            Map map = JaasLoginService.this.activeLogins;
            synchronized (map) {
                Iterator it = JaasLoginService.this.activeLogins.keySet().iterator();
                while (it.hasNext()) {
                    JaasClientId id = (JaasClientId)it.next();
                    JaasSecurityContext context = (JaasSecurityContext)JaasLoginService.this.activeLogins.get(id);
                    int age = (int)(now - context.getCreated());
                    if (!context.isDone() && age <= JaasLoginService.this.maxLoginDurationMillis) continue;
                    list.add(context);
                    context.setDone(true);
                    it.remove();
                }
            }
            Iterator it = list.iterator();
            while (it.hasNext()) {
                JaasSecurityContext context = (JaasSecurityContext)it.next();
                ContextManager.unregisterSubject(context.getSubject());
            }
        }
    }
}

