/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.io.Externalizable;
import java.io.Serializable;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.security.jaas.LoginModuleControlFlag;

public class JaasLoginModuleConfiguration
implements Serializable {
    private boolean serverSide;
    private String loginDomainName;
    private LoginModuleControlFlag flag;
    private String loginModuleName;
    private Map options;

    public JaasLoginModuleConfiguration(String loginModuleName, LoginModuleControlFlag flag, Map options, boolean serverSide, String loginDomainName) {
        this.serverSide = serverSide;
        this.flag = flag;
        this.loginModuleName = loginModuleName;
        this.options = options;
        this.loginDomainName = loginDomainName;
    }

    public JaasLoginModuleConfiguration(String loginModuleName, LoginModuleControlFlag flag, Map options, boolean serverSide) {
        this(loginModuleName, flag, options, serverSide, null);
    }

    public String getLoginModuleClassName() {
        return this.loginModuleName;
    }

    public LoginModule getLoginModule(ClassLoader loader) throws GeronimoSecurityException {
        try {
            return (LoginModule)loader.loadClass(this.loginModuleName).newInstance();
        }
        catch (Exception e) {
            throw new GeronimoSecurityException("Unable to instantiate login module", (Throwable)e);
        }
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public LoginModuleControlFlag getFlag() {
        return this.flag;
    }

    public Map getOptions() {
        return this.options;
    }

    public String getLoginDomainName() {
        return this.loginDomainName;
    }

    public JaasLoginModuleConfiguration getSerializableCopy() {
        HashMap other = new HashMap();
        Iterator it = this.options.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = this.options.get(key);
            if (!(value instanceof Serializable) && !(value instanceof Externalizable) && !(value instanceof Remote)) continue;
            other.put(key, value);
        }
        return new JaasLoginModuleConfiguration(this.loginModuleName, this.flag, other, this.serverSide, this.loginDomainName);
    }
}

