/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.deploy;

import java.beans.PropertyEditorManager;
import java.io.Serializable;
import org.apache.geronimo.common.propertyeditor.PropertyEditorException;
import org.apache.geronimo.common.propertyeditor.TextPropertyEditorSupport;

public class Principal
implements Serializable {
    private String className;
    private String principalName;
    private boolean designatedRunAs;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public boolean isDesignatedRunAs() {
        return this.designatedRunAs;
    }

    public void setDesignatedRunAs(boolean designatedRunAs) {
        this.designatedRunAs = designatedRunAs;
    }

    static {
        PropertyEditorManager.registerEditor(Principal.class, PrincipalEditor.class);
    }

    public static class PrincipalEditor
    extends TextPropertyEditorSupport {
        public void setAsText(String text) {
            if (text != null) {
                String[] parts = text.split("=");
                if (parts.length != 2) {
                    throw new PropertyEditorException("Principal should have the form 'name=class'");
                }
                Principal principal = new Principal();
                principal.setPrincipalName(parts[0]);
                principal.setClassName(parts[1]);
                this.setValue(principal);
            } else {
                this.setValue(null);
            }
        }

        public String getAsText() {
            Principal principal = (Principal)this.getValue();
            if (principal == null) {
                return null;
            }
            return principal.getPrincipalName() + "=" + principal.getClassName();
        }
    }
}

