/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security;

import java.security.Policy;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.security.GeronimoSecurityPermission;
import org.apache.geronimo.security.SecurityService;
import org.apache.geronimo.security.jacc.PolicyContextHandlerContainerSubject;
import org.apache.geronimo.security.jacc.PolicyContextHandlerHttpServletRequest;
import org.apache.geronimo.security.jacc.PolicyContextHandlerSOAPMessage;
import org.apache.geronimo.security.util.ConfigurationUtil;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class SecurityServiceImpl
implements SecurityService {
    public static boolean POLICY_INSTALLED = false;
    private final Log log = LogFactory.getLog((Class)SecurityServiceImpl.class);
    public static final GeronimoSecurityPermission CONFIGURE = new GeronimoSecurityPermission("configure");
    public static final GBeanInfo GBEAN_INFO;

    public SecurityServiceImpl(ClassLoader classLoader, ServerInfo serverInfo, String policyConfigurationFactory, String policyProvider, String keyStore, String keyStorePassword, String trustStore, String trustStorePassword) throws PolicyContextException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        ConfigurationUtil.registerPolicyContextHandler(new PolicyContextHandlerContainerSubject(), true);
        ConfigurationUtil.registerPolicyContextHandler(new PolicyContextHandlerSOAPMessage(), true);
        ConfigurationUtil.registerPolicyContextHandler(new PolicyContextHandlerHttpServletRequest(), true);
        if (!POLICY_INSTALLED) {
            if ((policyProvider = this.sysOverRide(policyProvider, "javax.security.jacc.policy.provider")) != null) {
                Policy policy = (Policy)classLoader.loadClass(policyProvider).newInstance();
                policy.refresh();
                Policy.setPolicy(policy);
            }
            POLICY_INSTALLED = true;
        }
        if ((policyConfigurationFactory = this.sysOverRide(policyConfigurationFactory, "javax.security.jacc.PolicyConfigurationFactory.provider")) != null) {
            PolicyConfigurationFactory.getPolicyConfigurationFactory();
        }
        if (keyStore != null) {
            this.sysOverRide(serverInfo.resolvePath(keyStore), "javax.net.ssl.keyStore");
        }
        if (keyStorePassword != null) {
            this.sysOverRide(keyStorePassword, "javax.net.ssl.keyStorePassword");
        }
        if (trustStore != null) {
            this.sysOverRide(serverInfo.resolvePath(trustStore), "javax.net.ssl.trustStore");
        }
        if (trustStorePassword != null) {
            this.sysOverRide(trustStorePassword, "javax.net.ssl.trustStorePassword");
        }
        this.log.debug((Object)("javax.net.ssl.keyStore: " + System.getProperty("javax.net.ssl.keyStore")));
        this.log.debug((Object)("javax.net.ssl.trustStore: " + System.getProperty("javax.net.ssl.trustStore")));
        this.log.info((Object)"JACC factory registered");
    }

    private String sysOverRide(String attribute, String sysVar) {
        String sysValue = System.getProperty(sysVar);
        if (sysValue != null) {
            return sysValue;
        }
        if (attribute != null) {
            System.setProperty(sysVar, attribute);
        }
        return attribute;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(SecurityServiceImpl.class);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addAttribute("policyConfigurationFactory", String.class, true);
        infoFactory.addAttribute("policyProvider", String.class, true);
        infoFactory.addAttribute("keyStore", String.class, true);
        infoFactory.addAttribute("keyStorePassword", String.class, true);
        infoFactory.addAttribute("trustStore", String.class, true);
        infoFactory.addAttribute("trustStorePassword", String.class, true);
        infoFactory.setConstructor(new String[]{"classLoader", "ServerInfo", "policyConfigurationFactory", "policyProvider", "keyStore", "keyStorePassword", "trustStore", "trustStorePassword"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

