/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.geronimo.security.util.URLPatternCheck;

public class URLPattern {
    private static final String[] HTTP_METHODS = new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE"};
    private static final int[] HTTP_MASKS = new int[]{1, 2, 4, 8, 16, 32, 64};
    private static final int NA = 0;
    private static final int INTEGRAL = 1;
    private static final int CONFIDENTIAL = 2;
    private URLPatternCheck type;
    private String pattern;
    private int mask;
    private int transport;
    private HashSet roles = new HashSet();
    private static final URLPatternCheck EXACT = new URLPatternCheck(){

        public boolean check(URLPattern base, URLPattern test) {
            return this.matches(base.pattern, test.pattern);
        }

        public boolean matches(String base, String test) {
            return base.equals(test);
        }
    };
    private static final URLPatternCheck PATH_PREFIX = new URLPatternCheck(){

        public boolean check(URLPattern base, URLPattern test) {
            return (test.type == PATH_PREFIX || test.type == EXACT) && base.matches(test) && !base.equals(test);
        }

        public boolean matches(String base, String test) {
            int length = base.length() - 2;
            if (length > test.length()) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (base.charAt(i) == test.charAt(i)) continue;
                return false;
            }
            if (test.length() == length) {
                return true;
            }
            return test.charAt(length) == '/';
        }
    };
    private static final URLPatternCheck EXTENSION = new URLPatternCheck(){

        public boolean check(URLPattern base, URLPattern test) {
            if (test.type == PATH_PREFIX) {
                return true;
            }
            if (test.type == EXACT) {
                return this.matches(base.pattern, test.pattern);
            }
            return false;
        }

        public boolean matches(String base, String test) {
            return test.endsWith(base.substring(1));
        }
    };
    private static final URLPatternCheck DEFAULT = new URLPatternCheck(){

        public boolean check(URLPattern base, URLPattern test) {
            return base.matches(test) && !base.equals(test);
        }

        public boolean matches(String base, String test) {
            return true;
        }
    };

    public URLPattern(String pat) {
        if (pat == null) {
            throw new IllegalArgumentException("URL pattern cannot be null");
        }
        if (pat.length() == 0) {
            throw new IllegalArgumentException("URL pattern cannot be empty");
        }
        this.type = pat.equals("/") || pat.equals("/*") ? DEFAULT : (pat.charAt(0) == '/' && pat.endsWith("/*") ? PATH_PREFIX : (pat.charAt(0) == '*' ? EXTENSION : EXACT));
        this.pattern = pat;
    }

    String getQualifiedPattern(HashSet patterns) {
        if (this.type == EXACT) {
            return this.pattern;
        }
        HashSet<String> bucket = new HashSet<String>();
        StringBuffer result = new StringBuffer(this.pattern);
        Iterator iter = patterns.iterator();
        while (iter.hasNext()) {
            URLPattern p = (URLPattern)iter.next();
            if (!this.type.check(this, p)) continue;
            bucket.add(p.pattern);
        }
        iter = bucket.iterator();
        while (iter.hasNext()) {
            result.append(':');
            result.append((String)iter.next());
        }
        return result.toString();
    }

    void addMethod(String method) {
        if (method.length() == 0) {
            this.mask = 255;
            return;
        }
        boolean found = false;
        for (int j = 0; j < HTTP_METHODS.length; ++j) {
            if (!method.equals(HTTP_METHODS[j])) continue;
            this.mask |= HTTP_MASKS[j];
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Invalid HTTP method");
        }
    }

    String getMethods() {
        StringBuffer buffer = null;
        for (int i = 0; i < HTTP_MASKS.length; ++i) {
            if ((this.mask & HTTP_MASKS[i]) <= 0) continue;
            if (buffer == null) {
                buffer = new StringBuffer();
            } else {
                buffer.append(",");
            }
            buffer.append(HTTP_METHODS[i]);
        }
        return buffer == null ? "" : buffer.toString();
    }

    String getComplementedMethods() {
        StringBuffer buffer = null;
        for (int i = 0; i < HTTP_MASKS.length; ++i) {
            if ((this.mask & HTTP_MASKS[i]) != 0) continue;
            if (buffer == null) {
                buffer = new StringBuffer();
            } else {
                buffer.append(",");
            }
            buffer.append(HTTP_METHODS[i]);
        }
        return buffer == null ? "" : buffer.toString();
    }

    String getMethodsWithTransport() {
        StringBuffer buffer = new StringBuffer(this.getMethods());
        if (this.transport != 0) {
            buffer.append(":");
            if (this.transport != 3) {
                if (this.transport == 1) {
                    buffer.append("INTEGRAL");
                } else {
                    buffer.append("CONFIDENTIAL");
                }
            }
        }
        return buffer.toString();
    }

    void setTransport(String trans) {
        switch (this.transport) {
            case 0: {
                if ("INTEGRAL".equals(trans)) {
                    this.transport = 1;
                    break;
                }
                if (!"CONFIDENTIAL".equals(trans)) break;
                this.transport = 2;
                break;
            }
            case 1: {
                if (!"CONFIDENTIAL".equals(trans)) break;
                this.transport = 2;
            }
        }
    }

    void addRole(String role) {
        this.roles.add(role);
    }

    void addAllRoles(Collection collection) {
        this.roles.addAll(collection);
    }

    HashSet getRoles() {
        return this.roles;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URLPattern)) {
            return false;
        }
        URLPattern test = (URLPattern)obj;
        return this.pattern.equals(test.pattern);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    boolean matches(URLPattern p) {
        String test = p.pattern;
        if (this.pattern.equals(test)) {
            return true;
        }
        return this.type.matches(this.pattern, test);
    }
}

