/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.util;

import java.security.Permission;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebUserDataPermission;
import org.apache.geronimo.security.GeronimoSecurityException;
import org.apache.geronimo.security.util.URLPattern;
import org.apache.geronimo.xbeans.j2ee.AssemblyDescriptorType;
import org.apache.geronimo.xbeans.j2ee.EjbJarType;
import org.apache.geronimo.xbeans.j2ee.EnterpriseBeansType;
import org.apache.geronimo.xbeans.j2ee.EntityBeanType;
import org.apache.geronimo.xbeans.j2ee.ExcludeListType;
import org.apache.geronimo.xbeans.j2ee.HttpMethodType;
import org.apache.geronimo.xbeans.j2ee.JavaTypeType;
import org.apache.geronimo.xbeans.j2ee.MethodPermissionType;
import org.apache.geronimo.xbeans.j2ee.MethodType;
import org.apache.geronimo.xbeans.j2ee.RoleNameType;
import org.apache.geronimo.xbeans.j2ee.SecurityConstraintType;
import org.apache.geronimo.xbeans.j2ee.SecurityRoleRefType;
import org.apache.geronimo.xbeans.j2ee.SecurityRoleType;
import org.apache.geronimo.xbeans.j2ee.SessionBeanType;
import org.apache.geronimo.xbeans.j2ee.UrlPatternType;
import org.apache.geronimo.xbeans.j2ee.WebAppType;
import org.apache.geronimo.xbeans.j2ee.WebResourceCollectionType;

public class ConfigurationUtil {
    public static void registerPolicyContextHandler(PolicyContextHandler handler, boolean replace) throws PolicyContextException {
        String[] keys = handler.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            PolicyContext.registerHandler((String)keys[i], (PolicyContextHandler)handler, (boolean)replace);
        }
    }

    public static void configure(PolicyConfiguration configuration, WebAppType webApp) throws GeronimoSecurityException {
        HashSet<RoleNameType> securityRoles = new HashSet<RoleNameType>();
        SecurityRoleType[] securityRolesArray = webApp.getSecurityRoleArray();
        for (int i = 0; i < securityRolesArray.length; ++i) {
            securityRoles.add(securityRolesArray[i].getRoleName());
        }
        HashMap<String, URLPattern> uncheckedPatterns = new HashMap<String, URLPattern>();
        HashMap excludedPatterns = new HashMap();
        HashMap rolesPatterns = new HashMap();
        HashSet<URLPattern> allSet = new HashSet<URLPattern>();
        HashMap<String, URLPattern> allMap = new HashMap<String, URLPattern>();
        SecurityConstraintType[] s = webApp.getSecurityConstraintArray();
        for (int i = 0; i < s.length; ++i) {
            HashMap<String, URLPattern> currentPatterns = s[i].getAuthConstraint() == null ? uncheckedPatterns : (s[i].getAuthConstraint().getRoleNameArray().length == 0 ? excludedPatterns : rolesPatterns);
            String transport = "";
            if (s[i].getUserDataConstraint() != null) {
                transport = s[i].getUserDataConstraint().getTransportGuarantee().getStringValue();
            }
            WebResourceCollectionType[] collection = s[i].getWebResourceCollectionArray();
            for (int j = 0; j < collection.length; ++j) {
                HttpMethodType[] methods = collection[j].getHttpMethodArray();
                UrlPatternType[] patterns = collection[j].getUrlPatternArray();
                for (int k = 0; k < patterns.length; ++k) {
                    URLPattern allPattern;
                    URLPattern pattern = (URLPattern)currentPatterns.get(patterns[k]);
                    if (pattern == null) {
                        pattern = new URLPattern(patterns[k].getStringValue());
                        currentPatterns.put(patterns[k].getStringValue(), pattern);
                    }
                    if ((allPattern = (URLPattern)allMap.get(patterns[k].getStringValue())) == null) {
                        allPattern = new URLPattern(patterns[k].getStringValue());
                        allSet.add(allPattern);
                        allMap.put(patterns[k].getStringValue(), allPattern);
                    }
                    for (int l = 0; l < methods.length; ++l) {
                        pattern.addMethod(methods[l].getStringValue());
                        allPattern.addMethod(methods[l].getStringValue());
                    }
                    if (methods.length == 0) {
                        pattern.addMethod("");
                        allPattern.addMethod("");
                    }
                    if (currentPatterns == rolesPatterns) {
                        RoleNameType[] roles = s[i].getAuthConstraint().getRoleNameArray();
                        for (int l = 0; l < roles.length; ++l) {
                            if (roles[l].getStringValue().equals("*")) {
                                pattern.addAllRoles(securityRoles);
                                continue;
                            }
                            pattern.addRole(roles[l].getStringValue());
                        }
                    }
                    pattern.setTransport(transport);
                }
            }
        }
        try {
            String actions;
            String name;
            URLPattern pattern;
            Iterator<Object> iter = excludedPatterns.keySet().iterator();
            while (iter.hasNext()) {
                pattern = (URLPattern)excludedPatterns.get(iter.next());
                name = pattern.getQualifiedPattern(allSet);
                actions = pattern.getMethods();
                configuration.addToExcludedPolicy((Permission)new WebResourcePermission(name, actions));
                configuration.addToExcludedPolicy((Permission)new WebUserDataPermission(name, actions));
            }
            iter = rolesPatterns.keySet().iterator();
            while (iter.hasNext()) {
                pattern = (URLPattern)rolesPatterns.get(iter.next());
                name = pattern.getQualifiedPattern(allSet);
                actions = pattern.getMethods();
                WebResourcePermission permission = new WebResourcePermission(name, actions);
                Iterator names = pattern.getRoles().iterator();
                while (names.hasNext()) {
                    configuration.addToRole((String)names.next(), (Permission)permission);
                }
            }
            iter = uncheckedPatterns.keySet().iterator();
            while (iter.hasNext()) {
                pattern = (URLPattern)uncheckedPatterns.get(iter.next());
                name = pattern.getQualifiedPattern(allSet);
                actions = pattern.getMethods();
                configuration.addToUncheckedPolicy((Permission)new WebResourcePermission(name, actions));
            }
            iter = rolesPatterns.keySet().iterator();
            while (iter.hasNext()) {
                pattern = (URLPattern)rolesPatterns.get(iter.next());
                name = pattern.getQualifiedPattern(allSet);
                actions = pattern.getMethodsWithTransport();
                configuration.addToUncheckedPolicy((Permission)new WebUserDataPermission(name, actions));
            }
            iter = uncheckedPatterns.keySet().iterator();
            while (iter.hasNext()) {
                pattern = (URLPattern)uncheckedPatterns.get(iter.next());
                name = pattern.getQualifiedPattern(allSet);
                actions = pattern.getMethodsWithTransport();
                configuration.addToUncheckedPolicy((Permission)new WebUserDataPermission(name, actions));
            }
            iter = allSet.iterator();
            while (iter.hasNext()) {
                pattern = (URLPattern)iter.next();
                name = pattern.getQualifiedPattern(allSet);
                actions = pattern.getComplementedMethods();
                if (actions.length() == 0) continue;
                configuration.addToUncheckedPolicy((Permission)new WebResourcePermission(name, actions));
                configuration.addToUncheckedPolicy((Permission)new WebUserDataPermission(name, actions));
            }
            pattern = new URLPattern("/");
            if (!allSet.contains(pattern)) {
                name = pattern.getQualifiedPattern(allSet);
                actions = pattern.getComplementedMethods();
                configuration.addToUncheckedPolicy((Permission)new WebResourcePermission(name, actions));
                configuration.addToUncheckedPolicy((Permission)new WebUserDataPermission(name, actions));
            }
        }
        catch (PolicyContextException e) {
            throw new GeronimoSecurityException(e);
        }
    }

    public static void configure(PolicyConfiguration configuration, EjbJarType ejbJar) throws GeronimoSecurityException {
        int i;
        EnterpriseBeansType enterpriseBeans = ejbJar.getEnterpriseBeans();
        EntityBeanType[] entityBeans = enterpriseBeans.getEntityArray();
        SessionBeanType[] sessionBeans = enterpriseBeans.getSessionArray();
        AssemblyDescriptorType assemblyDescriptor = ejbJar.getAssemblyDescriptor();
        MethodPermissionType[] methodPermissions = assemblyDescriptor.getMethodPermissionArray();
        ExcludeListType excludeList = assemblyDescriptor.getExcludeList();
        for (i = 0; i < methodPermissions.length; ++i) {
            MethodPermissionType methodPermission = methodPermissions[i];
            MethodType[] methods = methodPermission.getMethodArray();
            for (int j = 0; j < methods.length; ++j) {
                MethodType method = methods[j];
                EJBMethodPermission permission = new EJBMethodPermission(method.getEjbName().getStringValue(), method.getMethodName().getStringValue(), method.getMethodIntf().getStringValue(), ConfigurationUtil.toStringArray(method.getMethodParams().getMethodParamArray()));
                try {
                    if (methodPermission.getUnchecked() != null) {
                        configuration.addToUncheckedPolicy((Permission)permission);
                        continue;
                    }
                    RoleNameType[] roleNames = methodPermission.getRoleNameArray();
                    for (int k = 0; k < roleNames.length; ++k) {
                        configuration.addToRole(roleNames[k].getStringValue(), (Permission)permission);
                    }
                    continue;
                }
                catch (PolicyContextException e) {
                    throw new GeronimoSecurityException(e);
                }
            }
        }
        if (excludeList != null) {
            MethodType[] methods = excludeList.getMethodArray();
            try {
                for (int i2 = 0; i2 < methods.length; ++i2) {
                    EJBMethodPermission permission = new EJBMethodPermission(methods[i2].getEjbName().getStringValue(), methods[i2].getMethodName().getStringValue(), methods[i2].getMethodIntf().getStringValue(), ConfigurationUtil.toStringArray(methods[i2].getMethodParams().getMethodParamArray()));
                    configuration.addToExcludedPolicy((Permission)permission);
                }
            }
            catch (PolicyContextException e) {
                throw new GeronimoSecurityException(e);
            }
        }
        for (i = 0; i < entityBeans.length; ++i) {
            ConfigurationUtil.translateSecurityRoleRefs(configuration, entityBeans[i].getSecurityRoleRefArray(), entityBeans[i].getEjbName().getStringValue());
        }
        for (i = 0; i < sessionBeans.length; ++i) {
            ConfigurationUtil.translateSecurityRoleRefs(configuration, sessionBeans[i].getSecurityRoleRefArray(), sessionBeans[i].getEjbName().getStringValue());
        }
    }

    private static String[] toStringArray(JavaTypeType[] methodParamArray) {
        String[] result = new String[methodParamArray.length];
        for (int i = 0; i < methodParamArray.length; ++i) {
            result[i] = methodParamArray[i].getStringValue();
        }
        return result;
    }

    private static void translateSecurityRoleRefs(PolicyConfiguration configuration, SecurityRoleRefType[] roleRefs, String ejbName) throws GeronimoSecurityException {
        try {
            for (int i = 0; i < roleRefs.length; ++i) {
                String roleName = roleRefs[i].getRoleName().getStringValue();
                String roleLink = roleRefs[i].getRoleLink().getStringValue();
                configuration.addToRole(roleLink, (Permission)new EJBRoleRefPermission(ejbName, roleName));
            }
        }
        catch (PolicyContextException e) {
            throw new GeronimoSecurityException(e);
        }
    }
}

