/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GConstructorInfo;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.security.GeronimoSecurityException;
import org.apache.geronimo.security.realm.providers.AbstractSecurityRealm;
import org.apache.regexp.RE;

public class SQLSecurityRealm
extends AbstractSecurityRealm {
    private static final GBeanInfo GBEAN_INFO;
    public static final String USER_SELECT = "org.apache.geronimo.security.realm.providers.SQLSecurityRealm.USER_SELECT";
    public static final String GROUP_SELECT = "org.apache.geronimo.security.realm.providers.SQLSecurityRealm.GROUP_SELECT";
    public static final String CONNECTION_URL = "org.apache.geronimo.security.realm.providers.SQLSecurityRealm.CONNECTION_URL";
    public static final String USERNAME = "org.apache.geronimo.security.realm.providers.SQLSecurityRealm.USERNAME";
    public static final String PASSWORD = "org.apache.geronimo.security.realm.providers.SQLSecurityRealm.PASSWORD";
    private boolean running = false;
    private String connectionURL;
    private String user = "";
    private String password = "";
    private String userSelect = "SELECT UserName, Password FROM Users";
    private String groupSelect = "SELECT GroupName, UserName FROM Groups";
    final Map users = new HashMap();
    final Map groups = new HashMap();

    public SQLSecurityRealm() {
    }

    public SQLSecurityRealm(String realmName, String connectionURL, String user, String password, String userSelect, String groupSelect) {
        super(realmName);
        this.connectionURL = connectionURL;
        this.user = user;
        this.password = password;
        this.userSelect = userSelect;
        this.groupSelect = groupSelect;
    }

    public void doStart() {
        if (this.connectionURL == null) {
            throw new IllegalStateException("Connection URI not set");
        }
        this.refresh();
        this.running = true;
    }

    public void doStop() {
        this.running = false;
        this.users.clear();
        this.groups.clear();
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        if (this.running) {
            throw new IllegalStateException("Cannot change the Connection URI after the realm is started");
        }
        this.connectionURL = connectionURL;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String password) {
        if (this.running) {
            throw new IllegalStateException("Cannot change the connection password after the realm is started");
        }
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUser(String user) {
        if (this.running) {
            throw new IllegalStateException("Cannot change the connection user after the realm is started");
        }
        this.user = user;
    }

    public String getUserSelect() {
        return this.userSelect;
    }

    public void setUserSelect(String userSelect) {
        if (this.running) {
            throw new IllegalStateException("Cannot change the user SQL select statement after the realm is started");
        }
        this.userSelect = userSelect;
    }

    public String getGroupSelect() {
        return this.groupSelect;
    }

    public void setGroupSelect(String groupSelect) {
        if (this.running) {
            throw new IllegalStateException("Cannot change the group SQL select statement after the realm is started");
        }
        this.groupSelect = groupSelect;
    }

    public Set getGroupPrincipals() throws GeronimoSecurityException {
        if (!this.running) {
            throw new IllegalStateException("Cannot obtain Groups until the realm is started");
        }
        return Collections.unmodifiableSet(this.groups.keySet());
    }

    public Set getGroupPrincipals(RE regexExpression) throws GeronimoSecurityException {
        if (!this.running) {
            throw new IllegalStateException("Cannot obtain Groups until the realm is started");
        }
        HashSet<String> result = new HashSet<String>();
        Iterator iter = this.groups.keySet().iterator();
        while (iter.hasNext()) {
            String group = (String)iter.next();
            if (!regexExpression.match(group)) continue;
            result.add(group);
        }
        return result;
    }

    public Set getUserPrincipals() throws GeronimoSecurityException {
        if (!this.running) {
            throw new IllegalStateException("Cannot obtain Users until the realm is started");
        }
        return Collections.unmodifiableSet(this.users.keySet());
    }

    public Set getUserPrincipals(RE regexExpression) throws GeronimoSecurityException {
        if (!this.running) {
            throw new IllegalStateException("Cannot obtain Users until the realm is started");
        }
        HashSet<String> result = new HashSet<String>();
        Iterator iter = this.users.keySet().iterator();
        while (iter.hasNext()) {
            String user = (String)iter.next();
            if (!regexExpression.match(user)) continue;
            result.add(user);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws GeronimoSecurityException {
        this.users.clear();
        this.groups.clear();
        HashMap<String, String> users = new HashMap<String, String>();
        HashMap<String, HashSet<String>> groups = new HashMap<String, HashSet<String>>();
        try {
            Connection conn = DriverManager.getConnection(this.connectionURL, this.user, this.password);
            try {
                ResultSet result;
                PreparedStatement statement = conn.prepareStatement(this.userSelect);
                try {
                    result = statement.executeQuery();
                    try {
                        while (result.next()) {
                            String userName = result.getString(1);
                            String userPassword = result.getString(2);
                            users.put(userName, userPassword);
                        }
                    }
                    finally {
                        result.close();
                    }
                }
                finally {
                    statement.close();
                }
                statement = conn.prepareStatement(this.groupSelect);
                try {
                    result = statement.executeQuery();
                    try {
                        while (result.next()) {
                            String groupName = result.getString(1);
                            String userName = result.getString(2);
                            HashSet<String> userset = (HashSet<String>)groups.get(groupName);
                            if (userset == null) {
                                userset = new HashSet<String>();
                                groups.put(groupName, userset);
                            }
                            userset.add(userName);
                        }
                    }
                    finally {
                        result.close();
                    }
                }
                finally {
                    statement.close();
                }
            }
            finally {
                conn.close();
            }
            this.users.putAll(users);
            this.groups.putAll(groups);
        }
        catch (SQLException sqle) {
            throw new GeronimoSecurityException(sqle);
        }
    }

    String obfuscate(String password) {
        return password;
    }

    public AppConfigurationEntry getAppConfigurationEntry() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(USER_SELECT, this.userSelect);
        options.put(GROUP_SELECT, this.groupSelect);
        options.put(CONNECTION_URL, this.connectionURL);
        options.put(USERNAME, this.user);
        options.put(PASSWORD, this.password);
        AppConfigurationEntry entry = new AppConfigurationEntry("org.apache.geronimo.security.realm.providers.SQLLoginModule", AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT, options);
        return entry;
    }

    public boolean isLoginModuleLocal() {
        return true;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(SQLSecurityRealm.class.getName(), AbstractSecurityRealm.getGBeanInfo());
        infoFactory.addAttribute(new GAttributeInfo("ConnectionURL", true));
        infoFactory.addAttribute(new GAttributeInfo("User", true));
        infoFactory.addAttribute(new GAttributeInfo("Password", true));
        infoFactory.addAttribute(new GAttributeInfo("UserSelect", true));
        infoFactory.addAttribute(new GAttributeInfo("GroupSelect", true));
        infoFactory.addOperation(new GOperationInfo("isLoginModuleLocal"));
        infoFactory.setConstructor(new GConstructorInfo(new String[]{"RealmName", "ConnectionURL", "User", "Password", "UserSelect", "GroupSelect"}, new Class[]{String.class, String.class, String.class, String.class, String.class, String.class}));
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

