/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.security.realm.providers.SQLGroupPrincipal;
import org.apache.geronimo.security.realm.providers.SQLUserPrincipal;

public class SQLLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler handler;
    private String cbUsername;
    private String cbPassword;
    private String connectionURL;
    private String sqlUser;
    private String sqlPassword;
    private String userSelect;
    private String groupSelect;
    Set groups = new HashSet();

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = callbackHandler;
        this.connectionURL = (String)options.get("org.apache.geronimo.security.realm.providers.SQLSecurityRealm.CONNECTION_URL");
        this.sqlUser = (String)options.get("org.apache.geronimo.security.realm.providers.SQLSecurityRealm.USERNAME");
        this.sqlPassword = (String)options.get("org.apache.geronimo.security.realm.providers.SQLSecurityRealm.PASSWORD");
        this.userSelect = (String)options.get("org.apache.geronimo.security.realm.providers.SQLSecurityRealm.USER_SELECT");
        this.groupSelect = (String)options.get("org.apache.geronimo.security.realm.providers.SQLSecurityRealm.GROUP_SELECT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("User name"), new PasswordCallback("Password", false)};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        this.cbUsername = ((NameCallback)callbacks[0]).getName();
        this.cbPassword = new String(((PasswordCallback)callbacks[1]).getPassword());
        boolean found = false;
        try {
            Connection conn = DriverManager.getConnection(this.connectionURL, this.sqlUser, this.sqlPassword);
            try {
                PreparedStatement statement = conn.prepareStatement(this.userSelect);
                try {
                    ResultSet result2 = statement.executeQuery();
                    try {
                        while (result2.next()) {
                            String userName = result2.getString(1);
                            String userPassword = result2.getString(2);
                            if (!this.cbUsername.equals(userName) || !this.cbPassword.equals(userPassword)) continue;
                            found = true;
                            break;
                        }
                    }
                    finally {
                        result2.close();
                    }
                }
                finally {
                    statement.close();
                }
                if (!found) {
                    boolean result2 = false;
                    return result2;
                }
                statement = conn.prepareStatement(this.groupSelect);
                try {
                    ResultSet result = statement.executeQuery();
                    try {
                        while (result.next()) {
                            String groupName = result.getString(1);
                            String userName = result.getString(2);
                            if (!this.cbUsername.equals(userName)) continue;
                            this.groups.add(new SQLGroupPrincipal(groupName));
                        }
                        return true;
                    }
                    finally {
                        result.close();
                    }
                }
                finally {
                    statement.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException sqle) {
            throw (LoginException)new LoginException("SQL error").initCause(sqle);
        }
    }

    public boolean commit() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals();
        principals.add(new SQLUserPrincipal(this.cbUsername));
        Iterator iter = this.groups.iterator();
        while (iter.hasNext()) {
            principals.add((Principal)iter.next());
        }
        return true;
    }

    public boolean abort() throws LoginException {
        this.cbUsername = null;
        this.cbPassword = null;
        return true;
    }

    public boolean logout() throws LoginException {
        this.cbUsername = null;
        this.cbPassword = null;
        return true;
    }
}

