/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GConstructorInfo;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.security.GeronimoSecurityException;
import org.apache.geronimo.security.realm.providers.AbstractSecurityRealm;
import org.apache.regexp.RE;

public class PropertiesFileSecurityRealm
extends AbstractSecurityRealm {
    private static final GBeanInfo GBEAN_INFO;
    private boolean running = false;
    private URI usersURI;
    private URI groupsURI;
    Properties users = new Properties();
    Properties groups = new Properties();
    static final String REALM_INSTANCE = "org.apache.geronimo.security.realm.providers.PropertiesFileSecurityRealm";

    public PropertiesFileSecurityRealm() {
    }

    public PropertiesFileSecurityRealm(String realmName, URI usersURI, URI groupsURI) {
        super(realmName);
        this.setUsersURI(usersURI);
        this.setGroupsURI(groupsURI);
    }

    public void doStart() {
        if (this.usersURI == null) {
            throw new IllegalStateException("Users URI not set");
        }
        if (this.groupsURI == null) {
            throw new IllegalStateException("Groups URI not set");
        }
        this.refresh();
        this.running = true;
    }

    public void doStop() {
        this.users.clear();
        this.groups.clear();
        this.running = false;
    }

    public URI getUsersURI() {
        return this.usersURI;
    }

    public void setUsersURI(URI usersURI) {
        if (this.running) {
            throw new IllegalStateException("Cannot change the Users URI after the realm is started");
        }
        this.usersURI = usersURI == null ? null : usersURI.normalize();
    }

    public URI getGroupsURI() {
        return this.groupsURI;
    }

    public void setGroupsURI(URI groupsURI) {
        if (this.running) {
            throw new IllegalStateException("Cannot change the Groups URI after the realm is started");
        }
        this.groupsURI = groupsURI == null ? null : groupsURI.normalize();
    }

    public Set getGroupPrincipals() throws GeronimoSecurityException {
        if (!this.running) {
            throw new IllegalStateException("Cannot obtain Groups until the realm is started");
        }
        return Collections.unmodifiableSet(this.groups.keySet());
    }

    public Set getGroupPrincipals(RE regexExpression) throws GeronimoSecurityException {
        if (!this.running) {
            throw new IllegalStateException("Cannot obtain Groups until the realm is started");
        }
        HashSet<String> result = new HashSet<String>();
        Enumeration<Object> enumeration = this.groups.keys();
        while (enumeration.hasMoreElements()) {
            String group = (String)enumeration.nextElement();
            if (!regexExpression.match(group)) continue;
            result.add(group);
        }
        return result;
    }

    public Set getUserPrincipals() throws GeronimoSecurityException {
        if (!this.running) {
            throw new IllegalStateException("Cannot obtain Users until the realm is started");
        }
        return Collections.unmodifiableSet(this.users.keySet());
    }

    public Set getUserPrincipals(RE regexExpression) throws GeronimoSecurityException {
        if (!this.running) {
            throw new IllegalStateException("Cannot obtain Users until the realm is started");
        }
        HashSet<String> result = new HashSet<String>();
        Enumeration<Object> enumeration = this.users.keys();
        while (enumeration.hasMoreElements()) {
            String user = (String)enumeration.nextElement();
            if (!regexExpression.match(user)) continue;
            result.add(user);
        }
        return result;
    }

    public void refresh() throws GeronimoSecurityException {
        try {
            this.users.load(this.usersURI.toURL().openStream());
            Properties temp = new Properties();
            temp.load(this.groupsURI.toURL().openStream());
            Enumeration<Object> enumeration = temp.keys();
            while (enumeration.hasMoreElements()) {
                String groupName = (String)enumeration.nextElement();
                String[] userList = ((String)temp.get(groupName)).split(",");
                HashSet<String> userset = (HashSet<String>)this.groups.get(groupName);
                if (userset == null) {
                    userset = new HashSet<String>();
                    this.groups.put(groupName, userset);
                }
                for (int i = 0; i < userList.length; ++i) {
                    userset.add(userList[i]);
                }
            }
        }
        catch (IOException e) {
            throw new GeronimoSecurityException(e);
        }
    }

    public AppConfigurationEntry getAppConfigurationEntry() {
        HashMap<String, PropertiesFileSecurityRealm> options = new HashMap<String, PropertiesFileSecurityRealm>();
        options.put(REALM_INSTANCE, this);
        AppConfigurationEntry entry = new AppConfigurationEntry("org.apache.geronimo.security.realm.providers.PropertiesFileLoginModule", AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT, options);
        return entry;
    }

    public boolean isLoginModuleLocal() {
        return true;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(PropertiesFileSecurityRealm.class.getName(), AbstractSecurityRealm.getGBeanInfo());
        infoFactory.addAttribute(new GAttributeInfo("UsersURI", true));
        infoFactory.addAttribute(new GAttributeInfo("GroupsURI", true));
        infoFactory.addOperation(new GOperationInfo("isLoginModuleLocal"));
        infoFactory.setConstructor(new GConstructorInfo(new String[]{"RealmName", "UsersURI", "GroupsURI"}, new Class[]{String.class, URI.class, URI.class}));
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

