/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.security.realm.providers.PropertiesFileGroupPrincipal;
import org.apache.geronimo.security.realm.providers.PropertiesFileSecurityRealm;
import org.apache.geronimo.security.realm.providers.PropertiesFileUserPrincipal;

public class PropertiesFileLoginModule
implements LoginModule {
    PropertiesFileSecurityRealm realm;
    Subject subject;
    CallbackHandler handler;
    String username;
    String password;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.realm = (PropertiesFileSecurityRealm)options.get("org.apache.geronimo.security.realm.providers.PropertiesFileSecurityRealm");
        this.subject = subject;
        this.handler = callbackHandler;
    }

    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("User name"), new PasswordCallback("Password", false)};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        this.username = ((NameCallback)callbacks[0]).getName();
        this.password = this.realm.users.getProperty(this.username);
        return new String(((PasswordCallback)callbacks[1]).getPassword()).equals(this.password);
    }

    public boolean commit() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals();
        principals.add(new PropertiesFileUserPrincipal(this.username));
        Enumeration<Object> enumeration = this.realm.groups.keys();
        block0: while (enumeration.hasMoreElements()) {
            String groupName = (String)enumeration.nextElement();
            Set users = (Set)this.realm.groups.get(groupName);
            Iterator iter = users.iterator();
            while (iter.hasNext()) {
                String user = (String)iter.next();
                if (!this.username.equals(user)) continue;
                principals.add(new PropertiesFileGroupPrincipal(groupName));
                continue block0;
            }
        }
        return true;
    }

    public boolean abort() throws LoginException {
        this.username = null;
        this.password = null;
        return true;
    }

    public boolean logout() throws LoginException {
        this.username = null;
        this.password = null;
        return true;
    }
}

