/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.network.protocol;

import java.util.ArrayList;
import java.util.Collection;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.network.protocol.AbstractProtocol;
import org.apache.geronimo.network.protocol.DownPacket;
import org.apache.geronimo.network.protocol.MetadataSupport;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.UpPacket;
import org.apache.geronimo.network.protocol.control.BootstrapCook;
import org.apache.geronimo.network.protocol.control.ControlContext;
import org.apache.geronimo.network.protocol.control.commands.CreateInstanceMenuItem;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.network.protocol.PassthroughUpPacket;
import org.apache.geronimo.security.network.protocol.SubjectCarryingPacketReader;
import org.apache.geronimo.security.network.protocol.SubjectCarryingUpPacket;

public class SubjectCarryingServerProtocol
extends AbstractProtocol
implements BootstrapCook {
    private static final Log log = LogFactory.getLog((Class)SubjectCarryingServerProtocol.class);
    private Subject clientSubject;

    public void setup() throws ProtocolException {
        log.trace((Object)"Starting");
    }

    public void drain() throws ProtocolException {
        log.trace((Object)"Stopping");
    }

    public void teardown() throws ProtocolException {
    }

    public void sendUp(UpPacket packet) throws ProtocolException {
        log.trace((Object)"sendUp");
        UpPacket p = SubjectCarryingPacketReader.getInstance().read(packet.getBuffer());
        if (p instanceof PassthroughUpPacket) {
            MetadataSupport.setSubject((UpPacket)packet, (Subject)this.clientSubject);
            this.getUpProtocol().sendUp(packet);
        } else if (p instanceof SubjectCarryingUpPacket) {
            SubjectCarryingUpPacket subjectPacket = (SubjectCarryingUpPacket)p;
            this.clientSubject = ContextManager.getRegisteredSubject(subjectPacket.getSubjectId());
            MetadataSupport.setSubject((UpPacket)packet, (Subject)this.clientSubject);
            this.getUpProtocol().sendUp(packet);
        }
    }

    public void sendDown(DownPacket packet) throws ProtocolException {
        log.trace((Object)"sendDown");
        this.getDownProtocol().sendDown(packet);
    }

    public Collection cook(ControlContext context) {
        ArrayList<CreateInstanceMenuItem> list = new ArrayList<CreateInstanceMenuItem>(1);
        CreateInstanceMenuItem create = new CreateInstanceMenuItem();
        create.setClassName("org.apache.geronimo.security.network.protocol.SubjectCarryingClientProtocol");
        create.setInstanceId(context.assignId((Object)this));
        list.add(create);
        return list;
    }
}

