/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.network.protocol;

import java.security.AccessController;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.network.protocol.AbstractProtocol;
import org.apache.geronimo.network.protocol.DownPacket;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.UpPacket;
import org.apache.geronimo.security.IdentificationPrincipal;
import org.apache.geronimo.security.network.protocol.PassthroughDownPacket;
import org.apache.geronimo.security.network.protocol.SubjectCaryingDownPacket;

public class SubjectCarryingClientProtocol
extends AbstractProtocol {
    private static final Log log = LogFactory.getLog((Class)SubjectCarryingClientProtocol.class);
    private Subject clientSubject;

    public void setup() throws ProtocolException {
        log.trace((Object)"Starting");
    }

    public void drain() throws ProtocolException {
        log.trace((Object)"Stopping");
    }

    public void teardown() throws ProtocolException {
    }

    public void sendUp(UpPacket packet) throws ProtocolException {
        this.getUpProtocol().sendUp(packet);
    }

    public void sendDown(DownPacket packet) throws ProtocolException {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (this.clientSubject == subject) {
            PassthroughDownPacket passthroughPacket = new PassthroughDownPacket();
            passthroughPacket.setBuffers(packet.getBuffers());
            this.getDownProtocol().sendDown((DownPacket)passthroughPacket);
        } else {
            this.clientSubject = subject;
            Set principals = this.clientSubject.getPrincipals(IdentificationPrincipal.class);
            if (principals.isEmpty()) {
                PassthroughDownPacket passthroughPacket = new PassthroughDownPacket();
                passthroughPacket.setBuffers(packet.getBuffers());
                this.getDownProtocol().sendDown((DownPacket)passthroughPacket);
            } else {
                IdentificationPrincipal principal = (IdentificationPrincipal)principals.iterator().next();
                SubjectCaryingDownPacket subjectPacket = new SubjectCaryingDownPacket();
                subjectPacket.setSubjectId(principal.getId());
                subjectPacket.setBuffers(packet.getBuffers());
                this.getDownProtocol().sendDown((DownPacket)subjectPacket);
            }
        }
    }
}

