/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jacc;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import org.apache.geronimo.security.RealmPrincipal;
import org.apache.geronimo.security.jacc.GeronimoPolicyConfiguration;
import org.apache.geronimo.security.jacc.RoleMappingConfiguration;

public class PolicyConfigurationWeb
implements GeronimoPolicyConfiguration {
    private static final int OPEN = 1;
    private static final int IN_SERVICE = 2;
    private static final int DELETED = 3;
    private final String contextID;
    private int state;
    private HashMap rolePermissionsMap = new HashMap();
    private HashMap principalRoleMapping = new HashMap();
    private Permissions unchecked = null;
    private Permissions excluded = null;
    private HashMap principalPermissionsMap = new HashMap();

    PolicyConfigurationWeb(String contextID) {
        this.contextID = contextID;
        this.state = 1;
    }

    public String getContextID() throws PolicyContextException {
        return this.contextID;
    }

    public boolean implies(ProtectionDomain domain, Permission permission) {
        if (this.excluded != null && this.excluded.implies(permission)) {
            return false;
        }
        if (this.unchecked != null && this.unchecked.implies(permission)) {
            return true;
        }
        Principal[] principals = domain.getPrincipals();
        if (principals.length == 0) {
            return false;
        }
        for (int i = 0; i < principals.length; ++i) {
            Permissions permissions;
            Principal principal = principals[i];
            if (!(principal instanceof RealmPrincipal) || (permissions = (Permissions)this.principalPermissionsMap.get(principal)) == null || !permissions.implies(permission)) continue;
            return true;
        }
        return false;
    }

    public void addRoleMapping(String role, Collection principals) throws PolicyContextException {
        Iterator iter = principals.iterator();
        while (iter.hasNext()) {
            Principal principal = (Principal)iter.next();
            if (!(principal instanceof RealmPrincipal)) {
                throw new PolicyContextException("Principal not instance of RealmPrincipal");
            }
            HashSet<String> roles = (HashSet<String>)this.principalRoleMapping.get(principal);
            if (roles == null) {
                roles = new HashSet<String>();
                this.principalRoleMapping.put(principal, roles);
            }
            roles.add(role);
        }
    }

    public void addToRole(String roleName, PermissionCollection permissions) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        Enumeration<Permission> enumeration = permissions.elements();
        while (enumeration.hasMoreElements()) {
            this.addToRole(roleName, enumeration.nextElement());
        }
    }

    public void addToRole(String roleName, Permission permission) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        Permissions permissions = (Permissions)this.rolePermissionsMap.get(roleName);
        if (permissions == null) {
            permissions = new Permissions();
            this.rolePermissionsMap.put(roleName, permissions);
        }
        permissions.add(permission);
    }

    public void addToUncheckedPolicy(PermissionCollection permissions) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        Enumeration<Permission> enumeration = permissions.elements();
        while (enumeration.hasMoreElements()) {
            this.addToUncheckedPolicy(enumeration.nextElement());
        }
    }

    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        if (this.unchecked == null) {
            this.unchecked = new Permissions();
        }
        this.unchecked.add(permission);
    }

    public void addToExcludedPolicy(PermissionCollection permissions) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        Enumeration<Permission> enumeration = permissions.elements();
        while (enumeration.hasMoreElements()) {
            this.addToUncheckedPolicy(enumeration.nextElement());
        }
    }

    public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        if (this.excluded == null) {
            this.excluded = new Permissions();
        }
        this.excluded.add(permission);
    }

    public void removeRole(String roleName) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        this.rolePermissionsMap.remove(roleName);
    }

    public void removeUncheckedPolicy() throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        this.unchecked = null;
    }

    public void removeExcludedPolicy() throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        this.excluded = null;
    }

    public void linkConfiguration(PolicyConfiguration link) throws PolicyContextException {
        if (this.state != 1) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        RoleMappingConfiguration configuration = (RoleMappingConfiguration)link;
        Iterator principals = this.principalRoleMapping.keySet().iterator();
        while (principals.hasNext()) {
            Principal principal = (Principal)principals.next();
            Iterator roles = ((HashSet)this.principalRoleMapping.get(principal)).iterator();
            while (roles.hasNext()) {
                configuration.addRoleMapping((String)roles.next(), Collections.singletonList(principal));
            }
        }
        configuration.linkConfiguration(this);
    }

    public void delete() throws PolicyContextException {
        this.state = 3;
    }

    public void commit() throws PolicyContextException {
        if (this.state == 3) {
            throw new UnsupportedOperationException("Not in an open state");
        }
        Iterator principals = this.principalRoleMapping.keySet().iterator();
        while (principals.hasNext()) {
            Principal principal = (Principal)principals.next();
            Permissions principalPermissions = (Permissions)this.principalPermissionsMap.get(principal);
            if (principalPermissions == null) {
                principalPermissions = new Permissions();
                this.principalPermissionsMap.put(principal, principalPermissions);
            }
            Iterator roles = ((HashSet)this.principalRoleMapping.get(principal)).iterator();
            while (roles.hasNext()) {
                Enumeration<Permission> rolePermissions = ((Permissions)this.rolePermissionsMap.get(roles.next())).elements();
                while (rolePermissions.hasMoreElements()) {
                    principalPermissions.add(rolePermissions.nextElement());
                }
            }
        }
        this.state = 2;
    }

    public boolean inService() throws PolicyContextException {
        return this.state == 2;
    }
}

