/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jacc;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.HashSet;
import javax.security.jacc.PolicyConfiguration;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GConstructorInfo;
import org.apache.geronimo.security.GeronimoSecurityException;
import org.apache.geronimo.security.RealmPrincipal;
import org.apache.geronimo.security.jacc.AbstractModuleConfiguration;
import org.apache.geronimo.security.util.ConfigurationUtil;
import org.apache.geronimo.xbeans.geronimo.security.GerPrincipalType;
import org.apache.geronimo.xbeans.geronimo.security.GerRealmType;
import org.apache.geronimo.xbeans.geronimo.security.GerRoleMappingsType;
import org.apache.geronimo.xbeans.geronimo.security.GerRoleType;
import org.apache.geronimo.xbeans.geronimo.security.GerSecurityType;
import org.apache.geronimo.xbeans.j2ee.AssemblyDescriptorType;
import org.apache.geronimo.xbeans.j2ee.EjbJarType;
import org.apache.geronimo.xbeans.j2ee.SecurityRoleType;

public class EJBModuleConfiguration
extends AbstractModuleConfiguration {
    private static final GBeanInfo GBEAN_INFO;
    private EjbJarType ejbJar;
    private GerSecurityType security;

    public EJBModuleConfiguration(String contextId, EjbJarType ejbJar, GerSecurityType security) throws GeronimoSecurityException {
        super(contextId);
        this.ejbJar = ejbJar;
        this.security = security;
    }

    public void doStart() {
        GerRoleMappingsType roleMappings;
        PolicyConfiguration configuration = this.getPolicyConfiguration();
        AssemblyDescriptorType assemblyDescriptor = this.ejbJar.getAssemblyDescriptor();
        SecurityRoleType[] securityRoles = assemblyDescriptor.getSecurityRoleArray();
        for (int i = 0; i < securityRoles.length; ++i) {
            this.getRoles().add(securityRoles[i].getRoleName());
        }
        ConfigurationUtil.configure(configuration, this.ejbJar);
        this.setConfigured(true);
        if (this.security != null && (roleMappings = this.security.getRoleMappings()) != null) {
            GerRoleType[] roles = roleMappings.getRoleArray();
            for (int i = 0; i < roles.length; ++i) {
                GerRoleType role = roles[i];
                GerRealmType[] realms = role.getRealmArray();
                for (int j = 0; j < realms.length; ++j) {
                    GerRealmType realm = realms[j];
                    GerPrincipalType[] principals = realm.getPrincipalArray();
                    HashSet<RealmPrincipal> set = new HashSet<RealmPrincipal>();
                    for (int k = 0; k < principals.length; ++k) {
                        GerPrincipalType principal = principals[k];
                        Principal p = null;
                        try {
                            Class<?> clazz = Class.forName(principal.getClass1());
                            Constructor<?> constructor = clazz.getDeclaredConstructor(class$java$lang$String == null ? EJBModuleConfiguration.class$("java.lang.String") : class$java$lang$String);
                            p = (Principal)constructor.newInstance(principal.getName());
                            set.add(new RealmPrincipal(realm.getRealmName(), p));
                            continue;
                        }
                        catch (InstantiationException e) {
                            throw new GeronimoSecurityException(e);
                        }
                        catch (IllegalAccessException e) {
                            throw new GeronimoSecurityException(e);
                        }
                        catch (ClassNotFoundException e) {
                            throw new GeronimoSecurityException(e);
                        }
                        catch (NoSuchMethodException e) {
                            throw new GeronimoSecurityException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new GeronimoSecurityException(e);
                        }
                    }
                    super.addRoleMapping(role.getRoleName(), set);
                }
            }
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(EJBModuleConfiguration.class.getName(), AbstractModuleConfiguration.getGBeanInfo());
        infoFactory.addAttribute(new GAttributeInfo("EJBJar", true));
        infoFactory.addAttribute(new GAttributeInfo("Security", true));
        infoFactory.setConstructor(new GConstructorInfo(new String[]{"ContextID", "EJBJar", "Security"}, new Class[]{String.class, EjbJarType.class, GerSecurityType.class}));
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

