/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jacc;

import java.util.Collection;
import java.util.HashSet;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBean;
import org.apache.geronimo.gbean.GBeanContext;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.security.GeronimoSecurityException;
import org.apache.geronimo.security.jacc.ModuleConfiguration;
import org.apache.geronimo.security.jacc.RoleMappingConfiguration;

public abstract class AbstractModuleConfiguration
implements ModuleConfiguration,
GBean {
    private static final GBeanInfo GBEAN_INFO;
    public static final String BASE_OBJECT_NAME = "geronimo.security:type=ModuleConfiguration";
    private String contextId;
    private PolicyConfigurationFactory factory;
    private PolicyConfiguration policyConfiguration;
    private boolean configured = false;
    private HashSet roleNames = new HashSet();

    public AbstractModuleConfiguration(String contextId) throws GeronimoSecurityException {
        this.contextId = contextId;
        try {
            this.factory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            this.policyConfiguration = this.factory.getPolicyConfiguration(contextId, false);
        }
        catch (ClassNotFoundException e) {
            throw new GeronimoSecurityException("Unable to find PolicyConfigurationFactory", e);
        }
        catch (PolicyContextException e) {
            throw new GeronimoSecurityException("Unable to find policy configuration with that id", e);
        }
    }

    public void setGBeanContext(GBeanContext context) {
    }

    public void doStart() {
    }

    public void doStop() {
        this.delete();
    }

    public void doFail() {
    }

    public String getContextID() {
        return this.contextId;
    }

    protected void setConfigured(boolean configured) {
        this.configured = configured;
    }

    protected PolicyConfiguration getPolicyConfiguration() {
        return this.policyConfiguration;
    }

    public HashSet getRoles() {
        return this.roleNames;
    }

    public void addRoleMapping(String role, Collection principals) throws GeronimoSecurityException {
        if (!this.configured) {
            throw new GeronimoSecurityException("Must call configure() first");
        }
        try {
            RoleMappingConfiguration roleMapper = (RoleMappingConfiguration)this.policyConfiguration;
            if (!this.roleNames.contains(role)) {
                throw new GeronimoSecurityException("Role does not exist in this configuration");
            }
            roleMapper.addRoleMapping(role, principals);
        }
        catch (ClassCastException cce) {
            throw new GeronimoSecurityException("Policy configuration object does not implement RoleMappingConfiguration", cce.getCause());
        }
        catch (PolicyContextException pe) {
            throw new GeronimoSecurityException("Method addRoleMapping threw an exception", pe.getCause());
        }
    }

    public void linkConfiguration(ModuleConfiguration link) throws GeronimoSecurityException {
        PolicyConfiguration other;
        try {
            other = this.factory.getPolicyConfiguration(link.getContextID(), false);
        }
        catch (PolicyContextException e) {
            throw new GeronimoSecurityException("Unable to find policy configuration with that id", e);
        }
        if (other != null) {
            try {
                this.policyConfiguration.linkConfiguration(other);
            }
            catch (PolicyContextException e) {
                throw new GeronimoSecurityException("Unable to link configuration", e.getCause());
            }
        }
    }

    public void delete() throws GeronimoSecurityException {
        try {
            this.policyConfiguration.delete();
        }
        catch (PolicyContextException e) {
            throw new GeronimoSecurityException("Unable to delete configuration", e.getCause());
        }
    }

    public void commit() throws GeronimoSecurityException {
        try {
            this.policyConfiguration.commit();
        }
        catch (PolicyContextException e) {
            throw new GeronimoSecurityException("Unable to commit configuration", e.getCause());
        }
    }

    public boolean inService() throws GeronimoSecurityException {
        try {
            return this.policyConfiguration.inService();
        }
        catch (PolicyContextException e) {
            throw new GeronimoSecurityException("Unable to obtain inService state", e.getCause());
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(AbstractModuleConfiguration.class.getName());
        infoFactory.addAttribute(new GAttributeInfo("ContextID", true));
        infoFactory.addAttribute(new GAttributeInfo("Roles", true));
        infoFactory.addOperation(new GOperationInfo("addRoleMapping", new String[]{String.class.getName(), Collection.class.getName()}));
        infoFactory.addOperation(new GOperationInfo("linkConfiguration", new String[]{ModuleConfiguration.class.getName()}));
        infoFactory.addOperation(new GOperationInfo("commit"));
        infoFactory.addOperation(new GOperationInfo("inService"));
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

