/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.security.GeronimoSecurityException;
import org.apache.geronimo.security.RealmPrincipal;

public class RemoteLoginModuleRemoteWrapper
implements LoginModule {
    private String realm;
    private LoginModule module;
    private Subject internalSubject = new Subject();
    private Subject externalSubject;
    private static ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    });

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.externalSubject = subject;
        this.realm = (String)options.get("org.apache.geronimo.security.jaas.LoginModuleConstants.REALM_NAME");
        try {
            final String finalClass = (String)options.get("org.apache.geronimo.security.jaas.LoginModuleConstants.MODULE");
            this.module = (LoginModule)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
                    return Class.forName(finalClass, true, classLoader).newInstance();
                }
            });
            this.module.initialize(this.internalSubject, callbackHandler, sharedState, options);
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof InstantiationException) {
                throw (GeronimoSecurityException)new GeronimoSecurityException("Initialize error:" + e.getCause().getMessage() + "\n").initCause(e.getCause());
            }
            throw (GeronimoSecurityException)new GeronimoSecurityException("Initialize error: " + e.toString() + "\n").initCause(e);
        }
    }

    public boolean login() throws LoginException {
        return this.module.login();
    }

    public boolean commit() throws LoginException {
        if (!this.module.commit()) {
            return false;
        }
        Set<Principal> set = this.internalSubject.getPrincipals();
        Iterator<Principal> iter = set.iterator();
        while (iter.hasNext()) {
            RealmPrincipal principal = new RealmPrincipal(this.realm, iter.next());
            this.externalSubject.getPrincipals().add(principal);
        }
        this.externalSubject.getPrincipals().addAll(this.internalSubject.getPrincipals());
        this.externalSubject.getPrivateCredentials().addAll(this.internalSubject.getPrivateCredentials());
        this.externalSubject.getPublicCredentials().addAll(this.internalSubject.getPublicCredentials());
        return true;
    }

    public boolean abort() throws LoginException {
        return this.module.abort();
    }

    public boolean logout() throws LoginException {
        Iterator<Principal> pricipals = this.externalSubject.getPrincipals().iterator();
        while (pricipals.hasNext()) {
            Principal o = pricipals.next();
            if (o instanceof RealmPrincipal) {
                pricipals.remove();
            }
            if (!this.internalSubject.getPrincipals().contains(o)) continue;
            pricipals.remove();
        }
        Iterator<Object> privateCredentials = this.externalSubject.getPrivateCredentials().iterator();
        while (privateCredentials.hasNext()) {
            Object o = privateCredentials.next();
            if (!this.internalSubject.getPrivateCredentials().contains(o)) continue;
            privateCredentials.remove();
        }
        Iterator<Object> publicCredentials = this.externalSubject.getPublicCredentials().iterator();
        while (publicCredentials.hasNext()) {
            Object o = publicCredentials.next();
            if (!this.internalSubject.getPublicCredentials().contains(o)) continue;
            publicCredentials.remove();
        }
        return this.module.logout();
    }
}

