/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.security.RealmPrincipal;
import org.apache.geronimo.security.jaas.ExpiredLoginModuleException;
import org.apache.geronimo.security.jaas.LoginModuleId;
import org.apache.geronimo.security.jaas.LoginServiceMBean;

public class RemoteLoginModuleLocalWrapper
implements LoginModule {
    private String realmName;
    private LoginModuleId loginModuleId;
    private Subject internalSubject;
    private Subject externalSubject;
    private LoginServiceMBean remoteLoginService;
    private CallbackHandler callbackHandler;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.externalSubject = subject;
        this.callbackHandler = callbackHandler;
        this.realmName = (String)options.get("org.apache.geronimo.security.jaas.LoginModuleConstants.REALM_NAME");
        this.remoteLoginService = (LoginServiceMBean)options.get("org.apache.geronimo.security.jaas.RemoteLoginModule.LOGIN_SERVICE");
        try {
            this.loginModuleId = this.remoteLoginService.allocateLoginModule(this.realmName);
        }
        catch (LoginException e) {
            // empty catch block
        }
    }

    public boolean login() throws LoginException {
        if (this.loginModuleId == null) {
            throw new LoginException("No login module registered");
        }
        try {
            return this.tryLogin();
        }
        catch (ExpiredLoginModuleException ele) {
            try {
                this.loginModuleId = this.remoteLoginService.allocateLoginModule(this.realmName);
                return this.tryLogin();
            }
            catch (Exception e) {
                throw (LoginException)new LoginException().initCause(e);
            }
        }
        catch (Exception e) {
            throw (LoginException)new LoginException().initCause(e);
        }
    }

    public boolean commit() throws LoginException {
        if (this.loginModuleId == null) {
            throw new LoginException("No login module registered");
        }
        this.remoteLoginService.commit(this.loginModuleId);
        this.internalSubject = this.remoteLoginService.retrieveSubject(this.loginModuleId);
        this.externalSubject.getPrincipals().addAll(this.internalSubject.getPrincipals());
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.loginModuleId == null) {
            throw new LoginException("No login module registered");
        }
        return this.remoteLoginService.abort(this.loginModuleId);
    }

    public boolean logout() throws LoginException {
        if (this.loginModuleId == null) {
            throw new LoginException("No login module registered");
        }
        Iterator<Principal> pricipals = this.externalSubject.getPrincipals().iterator();
        while (pricipals.hasNext()) {
            Principal o = pricipals.next();
            if (o instanceof RealmPrincipal) {
                pricipals.remove();
                continue;
            }
            if (!this.internalSubject.getPrincipals().contains(o)) continue;
            pricipals.remove();
        }
        return this.remoteLoginService.logout(this.loginModuleId);
    }

    private boolean tryLogin() throws Exception {
        Collection collection = this.remoteLoginService.getCallbacks(this.loginModuleId);
        Callback[] callbacks = new Callback[]{};
        callbacks = collection.toArray(new Callback[0]);
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        ArrayList<Callback> list = new ArrayList<Callback>();
        for (int i = 0; i < callbacks.length; ++i) {
            list.add(callbacks[i]);
        }
        return this.remoteLoginService.login(this.loginModuleId, list);
    }

    protected void finalize() throws Throwable {
        if (this.loginModuleId != null) {
            this.remoteLoginService.removeLoginModule(this.loginModuleId);
        }
    }
}

