/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.security.GeronimoSecurityException;
import org.apache.geronimo.security.jaas.LoginServiceMBean;
import org.apache.geronimo.security.jaas.SerializableACE;
import org.apache.geronimo.security.remoting.jmx.RemoteLoginServiceFactory;

public class RemoteLoginModule
implements LoginModule {
    public static final String MODULE_IS_LOCAL = "org.apache.geronimo.security.jaas.RemoteLoginModule.MODULE_IS_LOCAL";
    public static final String LOGIN_URI = "org.apache.geronimo.security.jaas.RemoteLoginModule.LOGIN_URI";
    public static final String LOGIN_SERVICE = "org.apache.geronimo.security.jaas.RemoteLoginModule.LOGIN_SERVICE";
    private boolean debug;
    private URI connectURI;
    private LoginServiceMBean remoteLoginService;
    private LoginModule wrapper;
    private static ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    });

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        String uri = (String)options.get("uri");
        String realm = (String)options.get("realm");
        if (uri == null) {
            throw new GeronimoSecurityException("Initialize error: uri to sercurity service is not set");
        }
        if (realm == null) {
            throw new GeronimoSecurityException("Initialize error: realm name not specified");
        }
        try {
            this.connectURI = new URI(uri);
            this.remoteLoginService = RemoteLoginServiceFactory.create(this.connectURI.getHost(), this.connectURI.getPort());
            SerializableACE entry = this.remoteLoginService.getAppConfigurationEntry(realm);
            final String finalClass = entry.getLoginModuleName();
            this.wrapper = (LoginModule)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
                    return Class.forName(finalClass, true, classLoader).newInstance();
                }
            });
            HashMap<String, LoginServiceMBean> map = new HashMap<String, LoginServiceMBean>(entry.getOptions());
            map.put(LOGIN_SERVICE, this.remoteLoginService);
            this.wrapper.initialize(subject, callbackHandler, sharedState, map);
            if (this.debug) {
                System.out.print("[GeronimoLoginModule] Debug is  " + this.debug + " uri " + uri + " realm " + realm + "\n");
            }
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof InstantiationException) {
                throw (GeronimoSecurityException)new GeronimoSecurityException("Initialize error:" + e.getCause().getMessage()).initCause(e.getCause());
            }
            throw (GeronimoSecurityException)new GeronimoSecurityException("Initialize error: " + e.toString()).initCause(e);
        }
        catch (URISyntaxException e) {
            throw (GeronimoSecurityException)new GeronimoSecurityException("Initialize error: " + e.toString()).initCause(e);
        }
    }

    public boolean login() throws LoginException {
        if (this.wrapper == null) {
            throw new LoginException("RemoteLoginModule not properly initialzied");
        }
        return this.wrapper.login();
    }

    public boolean commit() throws LoginException {
        if (this.wrapper == null) {
            throw new LoginException("RemoteLoginModule not properly initialzied");
        }
        return this.wrapper.commit();
    }

    public boolean abort() throws LoginException {
        if (this.wrapper == null) {
            throw new LoginException("RemoteLoginModule not properly initialzied");
        }
        return this.wrapper.abort();
    }

    public boolean logout() throws LoginException {
        if (this.wrapper == null) {
            throw new LoginException("RemoteLoginModule not properly initialzied");
        }
        return this.wrapper.logout();
    }
}

