/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.IOException;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBean;
import org.apache.geronimo.gbean.GBeanContext;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.GeronimoSecurityException;
import org.apache.geronimo.security.IdentificationPrincipal;
import org.apache.geronimo.security.RealmPrincipal;
import org.apache.geronimo.security.SubjectId;
import org.apache.geronimo.security.jaas.ExpiredLoginModuleException;
import org.apache.geronimo.security.jaas.LoginModuleCacheObject;
import org.apache.geronimo.security.jaas.LoginModuleId;
import org.apache.geronimo.security.jaas.LoginServiceMBean;
import org.apache.geronimo.security.jaas.SerializableACE;
import org.apache.geronimo.security.realm.SecurityRealm;

public class LoginService
implements LoginServiceMBean,
GBean {
    private static final GBeanInfo GBEAN_INFO;
    public static final ObjectName LOGIN_SERVICE;
    private static final Log log;
    protected static final ClockDaemon clockDaemon;
    private Map loginCache = new Hashtable();
    private long reclaimPeriod;
    private Kernel kernel;
    private Collection realms = Collections.EMPTY_SET;
    private Collection loginModules = Collections.EMPTY_SET;
    private static final ClassLoader classLoader;
    private SecretKey key;
    private String algorithm;
    private String password;
    private static long nextLoginModuleId;
    static final /* synthetic */ boolean $assertionsDisabled;

    public long getReclaimPeriod() {
        return this.reclaimPeriod;
    }

    public void setReclaimPeriod(long reclaimPeriod) {
        this.reclaimPeriod = reclaimPeriod;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public Collection getRealms() throws GeronimoSecurityException {
        return this.realms;
    }

    public void setRealms(Collection realms) {
        this.realms = realms;
    }

    public Collection getLoginModules() throws GeronimoSecurityException {
        return this.loginModules;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SerializableACE getAppConfigurationEntry(String realmName) {
        Iterator iter = this.getRealms().iterator();
        while (iter.hasNext()) {
            SerializableACE wrapper;
            SecurityRealm securityRealm = (SecurityRealm)iter.next();
            if (!realmName.equals(securityRealm.getRealmName())) continue;
            AppConfigurationEntry entry = securityRealm.getAppConfigurationEntry();
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("org.apache.geronimo.security.jaas.LoginModuleConstants.REALM_NAME", realmName);
            options.put("org.apache.geronimo.security.jaas.LoginModuleConstants.MODULE", entry.getLoginModuleName());
            if (securityRealm.isLoginModuleLocal()) {
                wrapper = new SerializableACE("org.apache.geronimo.security.jaas.RemoteLoginModuleLocalWrapper", SerializableACE.LoginModuleControlFlag.REQUIRED, options);
            } else {
                options.putAll(entry.getOptions());
                wrapper = new SerializableACE("org.apache.geronimo.security.jaas.RemoteLoginModuleRemoteWrapper", SerializableACE.LoginModuleControlFlag.REQUIRED, options);
            }
            return wrapper;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoginModuleId allocateLoginModule(String realmName) {
        LoginModuleCacheObject lm = null;
        Class clazz = LoginService.class;
        synchronized (clazz) {
            try {
                Iterator iter = this.getRealms().iterator();
                while (iter.hasNext()) {
                    SecurityRealm securityRealm = (SecurityRealm)iter.next();
                    if (!realmName.equals(securityRealm.getRealmName())) continue;
                    AppConfigurationEntry entry = securityRealm.getAppConfigurationEntry();
                    final String finalClass = entry.getLoginModuleName();
                    LoginModule module = (LoginModule)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
                            return Class.forName(finalClass, true, classLoader).newInstance();
                        }
                    });
                    Subject subject = new Subject();
                    CallbackProxy callback = new CallbackProxy();
                    module.initialize(subject, callback, new HashMap(), entry.getOptions());
                    lm = this.allocateLoginModuleCacheObject(securityRealm.getMaxLoginModuleAge());
                    lm.setRealmName(realmName);
                    lm.setLoginModule(module);
                    lm.setSubject(subject);
                    lm.setCallbackHandler(callback);
                    log.trace((Object)("LoginModule [" + lm.getLoginModuleId() + "] created for realm " + realmName));
                    break;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return lm.getLoginModuleId();
    }

    public void removeLoginModule(LoginModuleId loginModuleId) throws ExpiredLoginModuleException {
        LoginModuleCacheObject lm = (LoginModuleCacheObject)this.loginCache.get(loginModuleId);
        if (lm == null) {
            throw new ExpiredLoginModuleException();
        }
        lm.setDone(true);
        log.trace((Object)("LoginModule [" + lm.getLoginModuleId() + "] marked done"));
    }

    public Collection getCallbacks(LoginModuleId loginModuleId) throws ExpiredLoginModuleException {
        LoginModuleCacheObject lm = (LoginModuleCacheObject)this.loginCache.get(loginModuleId);
        if (lm == null) {
            throw new ExpiredLoginModuleException();
        }
        LoginModule module = lm.getLoginModule();
        CallbackProxy callback = (CallbackProxy)lm.getCallbackHandler();
        try {
            module.login();
        }
        catch (LoginException e) {
            // empty catch block
        }
        try {
            module.abort();
        }
        catch (LoginException e) {
            // empty catch block
        }
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        for (int i = 0; i < callback.callbacks.length; ++i) {
            callbacks.add(callback.callbacks[i]);
        }
        return callbacks;
    }

    public boolean login(LoginModuleId loginModuleId, Collection callbacks) throws LoginException {
        LoginModuleCacheObject lm = (LoginModuleCacheObject)this.loginCache.get(loginModuleId);
        if (lm == null) {
            throw new ExpiredLoginModuleException();
        }
        LoginModule module = lm.getLoginModule();
        CallbackProxy callback = (CallbackProxy)lm.getCallbackHandler();
        callback.callbacks = callbacks.toArray(new Callback[0]);
        return module.login();
    }

    public boolean commit(LoginModuleId loginModuleId) throws LoginException {
        LoginModuleCacheObject lm = (LoginModuleCacheObject)this.loginCache.get(loginModuleId);
        if (lm == null) {
            throw new ExpiredLoginModuleException();
        }
        LoginModule module = lm.getLoginModule();
        if (!module.commit()) {
            return false;
        }
        Subject subject = lm.getSubject();
        HashSet<RealmPrincipal> principals = new HashSet<RealmPrincipal>();
        Iterator<Principal> iter = subject.getPrincipals().iterator();
        while (iter.hasNext()) {
            RealmPrincipal principal = new RealmPrincipal(lm.getRealmName(), iter.next());
            principals.add(ContextManager.registerPrincipal(principal));
        }
        subject.getPrincipals().addAll(principals);
        ContextManager.registerSubject(subject);
        SubjectId id = ContextManager.getSubjectId(lm.getSubject());
        subject.getPrincipals().add(new IdentificationPrincipal(id));
        return true;
    }

    public boolean abort(LoginModuleId loginModuleId) throws LoginException {
        LoginModuleCacheObject lm = (LoginModuleCacheObject)this.loginCache.get(loginModuleId);
        if (lm == null) {
            throw new ExpiredLoginModuleException();
        }
        LoginModule module = lm.getLoginModule();
        return module.abort();
    }

    public boolean logout(LoginModuleId loginModuleId) throws LoginException {
        LoginModuleCacheObject lm = (LoginModuleCacheObject)this.loginCache.get(loginModuleId);
        if (lm == null) {
            throw new ExpiredLoginModuleException();
        }
        lm.getSubject().getPrincipals(RealmPrincipal.class).clear();
        LoginModule module = lm.getLoginModule();
        return module.logout();
    }

    public Subject retrieveSubject(LoginModuleId loginModuleId) throws LoginException {
        LoginModuleCacheObject lm = (LoginModuleCacheObject)this.loginCache.get(loginModuleId);
        if (lm == null) {
            throw new ExpiredLoginModuleException();
        }
        return lm.getSubject();
    }

    private byte[] hash(Long id) {
        long n = id;
        byte[] bytes = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bytes[i] = (byte)n;
            n >>>= 8;
        }
        try {
            Mac mac = Mac.getInstance(this.algorithm);
            mac.init(this.key);
            mac.update(bytes);
            return mac.doFinal();
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeyException e) {
            // empty catch block
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Should never have reached here");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoginModuleCacheObject allocateLoginModuleCacheObject(long maxAge) {
        Map map = this.loginCache;
        synchronized (map) {
            Long id = new Long(nextLoginModuleId++);
            LoginModuleId loginModuleId = new LoginModuleId(id, this.hash(id));
            LoginModuleCacheObject lm = (LoginModuleCacheObject)this.loginCache.get(loginModuleId);
            if (lm == null) {
                lm = new LoginModuleCacheObject(loginModuleId);
                this.loginCache.put(loginModuleId, lm);
                LoginModuleCacheMonitor cm = new LoginModuleCacheMonitor(loginModuleId, lm, maxAge);
                cm.clockTicket = clockDaemon.executePeriodically(this.reclaimPeriod, (Runnable)cm, true);
            }
            return lm;
        }
    }

    public void setGBeanContext(GBeanContext context) {
    }

    public void doStart() throws WaitingException, Exception {
        this.key = new SecretKeySpec(this.password.getBytes(), this.algorithm);
        Mac mac = Mac.getInstance(this.algorithm);
        mac.init(this.key);
        log.info((Object)"Login server has been started");
    }

    public void doStop() throws WaitingException, Exception {
        clockDaemon.shutDown();
        Iterator keys = this.loginCache.keySet().iterator();
        while (keys.hasNext()) {
            LoginModuleCacheObject loginModule = (LoginModuleCacheObject)this.loginCache.get(keys.next());
            log.trace((Object)("LoginModule [" + loginModule.getLoginModuleId() + "] reclaimed"));
            ContextManager.unregisterSubject(loginModule.getSubject());
        }
        this.loginCache.clear();
        log.info((Object)"Login server has been stopped");
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !LoginService.class.desiredAssertionStatus();
        LOGIN_SERVICE = JMXUtil.getObjectName((String)"geronimo.security:type=LoginService");
        log = LogFactory.getLog((Class)LoginService.class);
        classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        clockDaemon = new ClockDaemon();
        clockDaemon.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "LoginService login modules monitor");
                t.setDaemon(true);
                return t;
            }
        });
        nextLoginModuleId = System.currentTimeMillis();
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(LoginService.class.getName());
        infoFactory.addOperation(new GOperationInfo("getAppConfigurationEntry", new String[]{String.class.getName()}));
        infoFactory.addOperation(new GOperationInfo("allocateLoginModule", new String[]{String.class.getName()}));
        infoFactory.addOperation(new GOperationInfo("getCallbacks", new String[]{LoginModuleId.class.getName()}));
        infoFactory.addOperation(new GOperationInfo("login", new String[]{LoginModuleId.class.getName(), Collection.class.getName()}));
        infoFactory.addOperation(new GOperationInfo("commit", new String[]{LoginModuleId.class.getName()}));
        infoFactory.addOperation(new GOperationInfo("abort", new String[]{LoginModuleId.class.getName()}));
        infoFactory.addOperation(new GOperationInfo("logout", new String[]{LoginModuleId.class.getName()}));
        infoFactory.addOperation(new GOperationInfo("retrieveSubject", new String[]{LoginModuleId.class.getName()}));
        infoFactory.addAttribute(new GAttributeInfo("Kernel", true));
        infoFactory.addAttribute(new GAttributeInfo("ReclaimPeriod", true));
        infoFactory.addAttribute(new GAttributeInfo("Algorithm", true));
        infoFactory.addAttribute(new GAttributeInfo("Password", true));
        infoFactory.addReference(new GReferenceInfo("Realms", SecurityRealm.class.getName()));
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private class LoginModuleCacheMonitor
    implements Runnable {
        final LoginModuleId key;
        final LoginModuleCacheObject loginModule;
        Object clockTicket;
        final long maxAge;

        LoginModuleCacheMonitor(LoginModuleId key, LoginModuleCacheObject loginModule, long maxAge) {
            this.key = key;
            this.loginModule = loginModule;
            this.maxAge = maxAge;
        }

        public void run() {
            long currentTime = System.currentTimeMillis();
            if (this.loginModule.isDone() || currentTime - this.loginModule.getCreated() > this.maxAge) {
                log.trace((Object)("LoginModule [" + this.loginModule.getLoginModuleId() + "] reclaimed"));
                ClockDaemon.cancel((Object)this.clockTicket);
                LoginService.this.loginCache.remove(this.key);
                ContextManager.unregisterSubject(this.loginModule.getSubject());
            }
        }
    }

    class CallbackProxy
    implements CallbackHandler {
        Callback[] callbacks;
        static final /* synthetic */ boolean $assertionsDisabled;

        CallbackProxy() {
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (this.callbacks == null) {
                this.callbacks = callbacks;
                throw new UnsupportedCallbackException(callbacks[0], "DO NOT PROCEED WITH THIS LOGIN");
            }
            if (!$assertionsDisabled && this.callbacks.length != callbacks.length) {
                throw new AssertionError((Object)"Callback lengths should not have changed");
            }
            for (int i = 0; i < callbacks.length; ++i) {
                callbacks[i] = this.callbacks[i];
            }
        }

        static {
            $assertionsDisabled = !(class$org$apache$geronimo$security$jaas$LoginService == null ? (class$org$apache$geronimo$security$jaas$LoginService = LoginService.class$("org.apache.geronimo.security.jaas.LoginService")) : class$org$apache$geronimo$security$jaas$LoginService).desiredAssertionStatus();
        }
    }
}

