/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.MBeanProxyFactory;
import org.apache.geronimo.security.GeronimoSecurityException;
import org.apache.geronimo.security.RealmPrincipal;
import org.apache.geronimo.security.jaas.ExpiredLoginModuleException;
import org.apache.geronimo.security.jaas.LoginModuleId;
import org.apache.geronimo.security.jaas.LoginService;
import org.apache.geronimo.security.jaas.LoginServiceMBean;

public class LocalLoginModule
implements LoginModule {
    private String realmName;
    private String kernelName;
    private Subject internalSubject = new Subject();
    private Subject externalSubject;
    private LoginModuleId loginModuleId;
    LoginServiceMBean loginService;
    private CallbackHandler callbackHandler;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.externalSubject = subject;
        this.callbackHandler = callbackHandler;
        this.realmName = (String)options.get("realm");
        this.kernelName = (String)options.get("kernel");
        try {
            Kernel kernel = Kernel.getKernel((String)this.kernelName);
            if (kernel == null) {
                throw new GeronimoSecurityException("No kernel found by the name of " + this.kernelName);
            }
            this.loginService = (LoginServiceMBean)MBeanProxyFactory.getProxy((Class)LoginServiceMBean.class, (MBeanServer)kernel.getMBeanServer(), (ObjectName)LoginService.LOGIN_SERVICE);
            this.loginModuleId = this.loginService.allocateLoginModule(this.realmName);
        }
        catch (Exception e) {
            throw (GeronimoSecurityException)new GeronimoSecurityException("Initialize error: " + e.toString() + "\n").initCause(e);
        }
    }

    public boolean login() throws LoginException {
        if (this.loginModuleId == null) {
            throw new LoginException("No login module registered");
        }
        try {
            return this.tryLogin();
        }
        catch (ExpiredLoginModuleException ele) {
            try {
                this.loginModuleId = this.loginService.allocateLoginModule(this.realmName);
                return this.tryLogin();
            }
            catch (Exception e) {
                throw (LoginException)new LoginException().initCause(e);
            }
        }
        catch (Exception e) {
            throw (LoginException)new LoginException().initCause(e);
        }
    }

    public boolean commit() throws LoginException {
        if (this.loginModuleId == null) {
            throw new LoginException("No login module registered");
        }
        this.loginService.commit(this.loginModuleId);
        this.internalSubject = this.loginService.retrieveSubject(this.loginModuleId);
        this.externalSubject.getPrincipals().addAll(this.internalSubject.getPrincipals());
        this.externalSubject.getPrivateCredentials().addAll(this.internalSubject.getPrivateCredentials());
        this.externalSubject.getPublicCredentials().addAll(this.internalSubject.getPublicCredentials());
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.loginModuleId == null) {
            throw new LoginException("No login module registered");
        }
        return this.loginService.abort(this.loginModuleId);
    }

    public boolean logout() throws LoginException {
        if (this.loginModuleId == null) {
            throw new LoginException("No login module registered");
        }
        Iterator<Principal> pricipals = this.externalSubject.getPrincipals().iterator();
        while (pricipals.hasNext()) {
            Principal o = pricipals.next();
            if (o instanceof RealmPrincipal) {
                pricipals.remove();
                continue;
            }
            if (!this.internalSubject.getPrincipals().contains(o)) continue;
            pricipals.remove();
        }
        Iterator<Object> privateCredentials = this.externalSubject.getPrivateCredentials().iterator();
        while (privateCredentials.hasNext()) {
            Object o = privateCredentials.next();
            if (!this.internalSubject.getPrivateCredentials().contains(o)) continue;
            privateCredentials.remove();
        }
        Iterator<Object> publicCredentials = this.externalSubject.getPublicCredentials().iterator();
        while (publicCredentials.hasNext()) {
            Object o = publicCredentials.next();
            if (!this.internalSubject.getPublicCredentials().contains(o)) continue;
            publicCredentials.remove();
        }
        return this.loginService.logout(this.loginModuleId);
    }

    private boolean tryLogin() throws Exception {
        Collection collection = this.loginService.getCallbacks(this.loginModuleId);
        Callback[] callbacks = new Callback[]{};
        callbacks = collection.toArray(new Callback[0]);
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        ArrayList<Callback> list = new ArrayList<Callback>();
        for (int i = 0; i < callbacks.length; ++i) {
            list.add(callbacks[i]);
        }
        return this.loginService.login(this.loginModuleId, list);
    }
}

