/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.bridge;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GConstructorInfo;
import org.apache.geronimo.security.bridge.AbstractPrincipalMappingUserPasswordRealmBridge;

public class PropertiesFilePrincipalMappingUserPasswordRealmBridge
extends AbstractPrincipalMappingUserPasswordRealmBridge {
    private static final GBeanInfo GBEAN_INFO;
    private URL propertyFileURL;

    public PropertiesFilePrincipalMappingUserPasswordRealmBridge() {
    }

    public PropertiesFilePrincipalMappingUserPasswordRealmBridge(String targetRealm, Class principalSourceType, String principalTargetCallbackName, Class userNameSourceType, String userNameTargetCallbackName, Class passwordSourceType, URL propertyFileURL) {
        super(targetRealm, principalSourceType, principalTargetCallbackName, userNameSourceType, userNameTargetCallbackName, passwordSourceType);
        this.propertyFileURL = propertyFileURL;
    }

    public URL getPropertyFileURL() {
        return this.propertyFileURL;
    }

    public void setPropertyFileURL(URL propertyFileURL) throws IOException {
        this.propertyFileURL = propertyFileURL;
        this.principalMap.clear();
        this.userNameMap.clear();
        this.passwordMap.clear();
        Properties properties = new Properties();
        properties.load(propertyFileURL.openStream());
        this.setMaps(properties, this.principalMap, this.userNameMap, this.passwordMap);
    }

    void setMaps(Properties properties, Map principalMap, Map userNameMap, Map passwordMap) {
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = (String)entry.getKey();
            String values = (String)entry.getValue();
            StringTokenizer tokenizer = new StringTokenizer(values, ":");
            String targetPrincipal = tokenizer.nextToken();
            String targetUserName = tokenizer.nextToken();
            char[] targetPassword = tokenizer.nextToken().toCharArray();
            principalMap.put(key, targetPrincipal);
            userNameMap.put(key, targetUserName);
            passwordMap.put(key, targetPassword);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(PropertiesFilePrincipalMappingUserPasswordRealmBridge.class.getName(), AbstractPrincipalMappingUserPasswordRealmBridge.getGBeanInfo());
        infoFactory.addAttribute(new GAttributeInfo("PropertyFileURL", true));
        infoFactory.setConstructor(new GConstructorInfo(new String[]{"TargetRealm", "PrincipalSourceType", "PrincipalTargetCallbackName", "UserNameSourceType", "UserNameTargetCallbackName", "PasswordSourceType", "PropertyFileURL"}, new Class[]{String.class, Class.class, String.class, Class.class, String.class, Class.class, URL.class}));
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

