/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.bridge;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GConstructorInfo;
import org.apache.geronimo.security.bridge.AbstractRealmBridge;
import org.apache.geronimo.security.bridge.CallerIdentityUserPasswordRealmBridge;

public abstract class AbstractPrincipalMappingUserPasswordRealmBridge
extends AbstractRealmBridge {
    private static final GBeanInfo GBEAN_INFO;
    protected final Map principalMap = new HashMap();
    private Class principalSourceType;
    private String principalTargetCallbackName;
    protected final Map userNameMap = new HashMap();
    private Class userNameSourceType;
    private String userNameTargetCallbackName;
    protected final Map passwordMap = new HashMap();
    private Class passwordSourceType;

    public AbstractPrincipalMappingUserPasswordRealmBridge() {
    }

    public AbstractPrincipalMappingUserPasswordRealmBridge(String targetRealm, Class principalSourceType, String principalTargetCallbackName, Class userNameSourceType, String userNameTargetCallbackName, Class passwordSourceType) {
        super(targetRealm);
        this.principalSourceType = principalSourceType;
        this.principalTargetCallbackName = principalTargetCallbackName;
        this.userNameSourceType = userNameSourceType;
        this.userNameTargetCallbackName = userNameTargetCallbackName;
        this.passwordSourceType = passwordSourceType;
    }

    public Class getPrincipalSourceType() {
        return this.principalSourceType;
    }

    public void setPrincipalSourceType(Class principalSourceType) {
        this.principalSourceType = principalSourceType;
    }

    public String getPrincipalTargetCallbackName() {
        return this.principalTargetCallbackName;
    }

    public void setPrincipalTargetCallbackName(String principalTargetCallbackName) {
        this.principalTargetCallbackName = principalTargetCallbackName;
    }

    public Class getUserNameSourceType() {
        return this.userNameSourceType;
    }

    public void setUserNameSourceType(Class userNameSourceType) {
        this.userNameSourceType = userNameSourceType;
    }

    public String getUserNameTargetCallbackName() {
        return this.userNameTargetCallbackName;
    }

    public void setUserNameTargetCallbackName(String userNameTargetCallbackName) {
        this.userNameTargetCallbackName = userNameTargetCallbackName;
    }

    public Class getPasswordSourceType() {
        return this.passwordSourceType;
    }

    public void setPasswordSourceType(Class passwordSourceType) {
        this.passwordSourceType = passwordSourceType;
    }

    protected CallbackHandler getCallbackHandler(final Subject sourceSubject) {
        return new CallbackHandler(){

            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                Principal principalSourcePrincipal = this.findPrincipalOfType(sourceSubject, AbstractPrincipalMappingUserPasswordRealmBridge.this.principalSourceType);
                Principal userNameSourcePrincipal = AbstractPrincipalMappingUserPasswordRealmBridge.this.userNameSourceType == AbstractPrincipalMappingUserPasswordRealmBridge.this.principalSourceType ? principalSourcePrincipal : this.findPrincipalOfType(sourceSubject, AbstractPrincipalMappingUserPasswordRealmBridge.this.userNameSourceType);
                Principal passwordSourcePrincipal = AbstractPrincipalMappingUserPasswordRealmBridge.this.passwordSourceType == AbstractPrincipalMappingUserPasswordRealmBridge.this.principalSourceType ? principalSourcePrincipal : this.findPrincipalOfType(sourceSubject, AbstractPrincipalMappingUserPasswordRealmBridge.this.passwordSourceType);
                for (int i = 0; i < callbacks.length; ++i) {
                    Callback callback = callbacks[i];
                    if (callback instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)callback;
                        if (nameCallback.getPrompt().equals(AbstractPrincipalMappingUserPasswordRealmBridge.this.principalTargetCallbackName)) {
                            nameCallback.setName((String)AbstractPrincipalMappingUserPasswordRealmBridge.this.principalMap.get(principalSourcePrincipal.getName()));
                            continue;
                        }
                        if (nameCallback.getPrompt().equals(AbstractPrincipalMappingUserPasswordRealmBridge.this.userNameTargetCallbackName)) {
                            nameCallback.setName((String)AbstractPrincipalMappingUserPasswordRealmBridge.this.userNameMap.get(userNameSourcePrincipal.getName()));
                            continue;
                        }
                        throw new UnsupportedCallbackException(callback, "Only name callbacks with prompts " + AbstractPrincipalMappingUserPasswordRealmBridge.this.principalTargetCallbackName + " or " + AbstractPrincipalMappingUserPasswordRealmBridge.this.userNameTargetCallbackName + " are supported");
                    }
                    if (callback instanceof PasswordCallback) {
                        ((PasswordCallback)callback).setPassword((char[])AbstractPrincipalMappingUserPasswordRealmBridge.this.passwordMap.get(passwordSourcePrincipal.getName()));
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback, "Only name and password callbacks supported");
                }
            }

            private Principal findPrincipalOfType(Subject sourceSubject2, Class principalClass) throws UnsupportedCallbackException {
                Set principalPrincipals = sourceSubject2.getPrincipals(principalClass);
                if (principalPrincipals == null || principalPrincipals.size() != 1) {
                    throw new UnsupportedCallbackException(null, "No principals of type " + principalClass + " to read");
                }
                Principal principal = (Principal)principalPrincipals.iterator().next();
                return principal;
            }
        };
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(CallerIdentityUserPasswordRealmBridge.class.getName(), AbstractRealmBridge.getGBeanInfo());
        infoFactory.addAttribute(new GAttributeInfo("PrincipalSourceType", true));
        infoFactory.addAttribute(new GAttributeInfo("PrincipalTargetCallbackName", true));
        infoFactory.addAttribute(new GAttributeInfo("UserNameSourceType", true));
        infoFactory.addAttribute(new GAttributeInfo("UserNameTargetCallbackName", true));
        infoFactory.addAttribute(new GAttributeInfo("PasswordSourceType", true));
        infoFactory.setConstructor(new GConstructorInfo(new String[]{"TargetRealm", "PrincipalSourceType", "PrincipalTargetCallbackName", "UserNameSourceType", "UserNameTargetCallbackName", "PasswordSourceType"}, new Class[]{String.class, Class.class, String.class, Class.class, String.class, Class.class}));
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

