/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security;

import java.util.Collection;
import java.util.Collections;
import javax.management.ObjectName;
import javax.security.jacc.PolicyContextException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBean;
import org.apache.geronimo.gbean.GBeanContext;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GConstructorInfo;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.security.GeronimoSecurityException;
import org.apache.geronimo.security.GeronimoSecurityPermission;
import org.apache.geronimo.security.SecurityServiceMBean;
import org.apache.geronimo.security.jacc.ModuleConfiguration;
import org.apache.geronimo.security.jacc.PolicyContextHandlerContainerSubject;
import org.apache.geronimo.security.jacc.PolicyContextHandlerHttpServletRequest;
import org.apache.geronimo.security.jacc.PolicyContextHandlerSOAPMessage;
import org.apache.geronimo.security.realm.SecurityRealm;
import org.apache.geronimo.security.util.ConfigurationUtil;

public class SecurityService
implements SecurityServiceMBean,
GBean {
    private static final GBeanInfo GBEAN_INFO;
    public static final ObjectName SECURITY;
    private final Log log = LogFactory.getLog((Class)SecurityServiceMBean.class);
    private String policyConfigurationFactory;
    private Collection realms = Collections.EMPTY_SET;
    private Collection moduleConfigurations = Collections.EMPTY_SET;
    public static final GeronimoSecurityPermission CONFIGURE;

    public SecurityService() {
        this(null);
    }

    public SecurityService(String policyConfigurationFactory) {
        try {
            ConfigurationUtil.registerPolicyContextHandler(new PolicyContextHandlerContainerSubject(), true);
            ConfigurationUtil.registerPolicyContextHandler(new PolicyContextHandlerSOAPMessage(), true);
            ConfigurationUtil.registerPolicyContextHandler(new PolicyContextHandlerHttpServletRequest(), true);
        }
        catch (PolicyContextException pce) {
            this.log.error((Object)"Exception in doStart()", (Throwable)pce);
            throw (IllegalStateException)new IllegalStateException().initCause(pce);
        }
        this.setPolicyConfigurationFactory(policyConfigurationFactory);
    }

    public String getPolicyConfigurationFactory() {
        return this.policyConfigurationFactory;
    }

    public void setPolicyConfigurationFactory(String policyConfigurationFactory) {
        this.policyConfigurationFactory = policyConfigurationFactory;
        if (policyConfigurationFactory != null) {
            System.setProperty("javax.security.jacc.PolicyConfigurationFactory.provider", policyConfigurationFactory);
        }
    }

    public Collection getRealms() throws GeronimoSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONFIGURE);
        }
        return this.realms;
    }

    public void setRealms(Collection realms) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONFIGURE);
        }
        this.realms = realms;
    }

    public Collection getModuleConfigurations() {
        return this.moduleConfigurations;
    }

    public void setModuleConfigurations(Collection moduleConfigurations) {
        this.moduleConfigurations = moduleConfigurations;
    }

    public void setGBeanContext(GBeanContext context) {
    }

    public void doStart() throws WaitingException, Exception {
    }

    public void doStop() throws WaitingException, Exception {
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        SECURITY = JMXUtil.getObjectName((String)"geronimo.security:type=SecurityService");
        CONFIGURE = new GeronimoSecurityPermission("configure");
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(SecurityService.class.getName());
        infoFactory.addAttribute(new GAttributeInfo("PolicyConfigurationFactory", true));
        infoFactory.addReference(new GReferenceInfo("Realms", SecurityRealm.class.getName()));
        infoFactory.addReference(new GReferenceInfo("ModuleConfigurations", ModuleConfiguration.class.getName()));
        infoFactory.setConstructor(new GConstructorInfo(new String[]{"PolicyConfigurationFactory"}, new Class[]{String.class}));
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

