/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security;

import java.io.Serializable;
import java.security.Principal;

public class RealmPrincipal
implements Principal,
Serializable {
    private final String realm;
    private final Principal principal;
    private transient String name = null;
    private transient long id;

    public RealmPrincipal(String realm, Principal principal) {
        if (realm == null) {
            throw new IllegalArgumentException("realm == null");
        }
        if (principal == null) {
            throw new IllegalArgumentException("principal == null");
        }
        this.realm = realm;
        this.principal = principal;
    }

    public long getId() {
        return this.id;
    }

    void setId(long id) {
        this.id = id;
    }

    public boolean equals(Object another) {
        if (!(another instanceof RealmPrincipal)) {
            return false;
        }
        RealmPrincipal realmPrincipal = (RealmPrincipal)another;
        return this.realm.equals(realmPrincipal.realm) && ((Object)this.principal).equals(realmPrincipal.principal);
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getName() {
        if (this.name == null) {
            StringBuffer buffer = new StringBuffer("");
            buffer.append(this.realm);
            buffer.append(":[");
            buffer.append(this.principal.getClass().getName());
            buffer.append(':');
            buffer.append(this.principal.getName());
            buffer.append("]");
            this.name = buffer.toString();
        }
        return this.name;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public String getRealm() {
        return this.realm;
    }
}

