/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.deployment;

import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.security.DomainPrincipal;
import org.apache.geronimo.security.RealmPrincipal;
import org.apache.geronimo.security.deploy.DefaultPrincipal;
import org.apache.geronimo.security.deploy.DistinguishedName;
import org.apache.geronimo.security.deploy.LoginDomainPrincipalInfo;
import org.apache.geronimo.security.deploy.PrincipalInfo;
import org.apache.geronimo.security.deploy.RealmPrincipalInfo;
import org.apache.geronimo.security.deploy.Role;
import org.apache.geronimo.security.deploy.Security;
import org.apache.geronimo.security.deployment.SecurityConfiguration;
import org.apache.geronimo.security.jaas.NamedUsernamePasswordCredential;
import org.apache.geronimo.security.jacc.ApplicationPolicyConfigurationManager;
import org.apache.geronimo.security.jacc.ApplicationPrincipalRoleConfigurationManager;
import org.apache.geronimo.security.util.ConfigurationUtil;
import org.apache.geronimo.xbeans.geronimo.security.GerDefaultPrincipalType;
import org.apache.geronimo.xbeans.geronimo.security.GerDistinguishedNameType;
import org.apache.geronimo.xbeans.geronimo.security.GerLoginDomainPrincipalType;
import org.apache.geronimo.xbeans.geronimo.security.GerNamedUsernamePasswordCredentialType;
import org.apache.geronimo.xbeans.geronimo.security.GerPrincipalType;
import org.apache.geronimo.xbeans.geronimo.security.GerRealmPrincipalType;
import org.apache.geronimo.xbeans.geronimo.security.GerRoleMappingsType;
import org.apache.geronimo.xbeans.geronimo.security.GerRoleType;
import org.apache.geronimo.xbeans.geronimo.security.GerSecurityType;

public class SecurityBuilder {
    public static SecurityConfiguration buildSecurityConfiguration(GerSecurityType securityType, ClassLoader classLoader) {
        Security security = SecurityBuilder.buildSecurityConfig(securityType);
        return SecurityBuilder.buildSecurityConfiguration(security, classLoader);
    }

    public static SecurityConfiguration buildSecurityConfiguration(Security security, ClassLoader classLoader) {
        HashMap roleDesignates = new HashMap();
        HashMap principalRoleMap = new HashMap();
        HashMap roleToPrincipalMap = new HashMap();
        SecurityBuilder.buildRolePrincipalMap(security, roleDesignates, roleToPrincipalMap, classLoader);
        SecurityBuilder.invertMap(roleToPrincipalMap, principalRoleMap);
        return new SecurityConfiguration(principalRoleMap, roleDesignates, security.getDefaultPrincipal(), security.getDefaultRole(), security.isDoAsCurrentCaller(), security.isUseContextHandler());
    }

    private static Map invertMap(Map roleToPrincipalMap, Map principalRoleMapping) {
        Iterator roles = roleToPrincipalMap.entrySet().iterator();
        while (roles.hasNext()) {
            Map.Entry entry = roles.next();
            String role = (String)entry.getKey();
            Set principals = (Set)entry.getValue();
            Iterator iter = principals.iterator();
            while (iter.hasNext()) {
                Principal principal = (Principal)iter.next();
                HashSet<String> roleSet = (HashSet<String>)principalRoleMapping.get(principal);
                if (roleSet == null) {
                    roleSet = new HashSet<String>();
                    principalRoleMapping.put(principal, roleSet);
                }
                roleSet.add(role);
            }
        }
        return principalRoleMapping;
    }

    public static void buildRolePrincipalMap(Security security, Map roleDesignates, Map roleToPrincipalMap, ClassLoader classLoader) {
        Iterator roleMappings = security.getRoleMappings().values().iterator();
        while (roleMappings.hasNext()) {
            Role role = (Role)roleMappings.next();
            String roleName = role.getRoleName();
            Subject roleDesignate = new Subject();
            HashSet<Object> principalSet = new HashSet<Object>();
            Iterator realmPrincipals = role.getRealmPrincipals().iterator();
            while (realmPrincipals.hasNext()) {
                RealmPrincipalInfo realmPrincipal = (RealmPrincipalInfo)realmPrincipals.next();
                RealmPrincipal principal = ConfigurationUtil.generateRealmPrincipal((String)realmPrincipal.getRealm(), (String)realmPrincipal.getDomain(), (PrincipalInfo)realmPrincipal, (ClassLoader)classLoader);
                principalSet.add(principal);
                if (!realmPrincipal.isDesignatedRunAs()) continue;
                roleDesignate.getPrincipals().add((Principal)principal);
            }
            Iterator domainPrincipals = role.getLoginDomainPrincipals().iterator();
            while (domainPrincipals.hasNext()) {
                LoginDomainPrincipalInfo domainPrincipal = (LoginDomainPrincipalInfo)domainPrincipals.next();
                DomainPrincipal principal = ConfigurationUtil.generateDomainPrincipal((String)domainPrincipal.getDomain(), (PrincipalInfo)domainPrincipal, (ClassLoader)classLoader);
                principalSet.add(principal);
                if (!domainPrincipal.isDesignatedRunAs()) continue;
                roleDesignate.getPrincipals().add((Principal)principal);
            }
            Iterator principals = role.getPrincipals().iterator();
            while (principals.hasNext()) {
                PrincipalInfo plainPrincipalInfo = (PrincipalInfo)principals.next();
                Principal principal = ConfigurationUtil.generatePrincipal((PrincipalInfo)plainPrincipalInfo, (ClassLoader)classLoader);
                principalSet.add(principal);
                if (!plainPrincipalInfo.isDesignatedRunAs()) continue;
                roleDesignate.getPrincipals().add(principal);
            }
            Iterator names = role.getDistinguishedNames().iterator();
            while (names.hasNext()) {
                DistinguishedName dn = (DistinguishedName)names.next();
                X500Principal x500Principal = ConfigurationUtil.generateX500Principal((String)dn.getName());
                principalSet.add(x500Principal);
                if (!dn.isDesignatedRunAs()) continue;
                roleDesignate.getPrincipals().add(x500Principal);
            }
            HashSet roleMapping = (HashSet)roleToPrincipalMap.get(roleName);
            if (roleMapping == null) {
                roleMapping = new HashSet();
                roleToPrincipalMap.put(roleName, roleMapping);
            }
            roleMapping.addAll(principalSet);
            if (roleDesignate.getPrincipals().size() <= 0) continue;
            roleDesignates.put(roleName, roleDesignate);
        }
    }

    private static Security buildSecurityConfig(GerSecurityType securityType) {
        if (securityType == null) {
            return null;
        }
        Security security = new Security();
        security.setDoAsCurrentCaller(securityType.getDoasCurrentCaller());
        security.setUseContextHandler(securityType.getUseContextHandler());
        if (securityType.isSetDefaultRole()) {
            security.setDefaultRole(securityType.getDefaultRole().trim());
        }
        if (securityType.isSetRoleMappings()) {
            GerRoleMappingsType roleMappingsType = securityType.getRoleMappings();
            for (int i = 0; i < roleMappingsType.sizeOfRoleArray(); ++i) {
                int j;
                GerRoleType roleType = roleMappingsType.getRoleArray(i);
                Role role = new Role();
                String roleName = roleType.getRoleName().trim();
                role.setRoleName(roleName);
                for (j = 0; j < roleType.sizeOfRealmPrincipalArray(); ++j) {
                    role.getRealmPrincipals().add(SecurityBuilder.buildRealmPrincipal(roleType.getRealmPrincipalArray(j)));
                }
                for (j = 0; j < roleType.sizeOfLoginDomainPrincipalArray(); ++j) {
                    role.getLoginDomainPrincipals().add(SecurityBuilder.buildDomainPrincipal(roleType.getLoginDomainPrincipalArray(j)));
                }
                for (j = 0; j < roleType.sizeOfPrincipalArray(); ++j) {
                    role.getPrincipals().add(SecurityBuilder.buildPrincipal(roleType.getPrincipalArray(j)));
                }
                for (j = 0; j < roleType.sizeOfDistinguishedNameArray(); ++j) {
                    GerDistinguishedNameType dnType = roleType.getDistinguishedNameArray(j);
                    role.getDistinguishedNames().add(new DistinguishedName(dnType.getName().trim(), dnType.getDesignatedRunAs()));
                }
                security.getRoleMappings().put(roleName, role);
            }
        }
        security.setDefaultPrincipal(SecurityBuilder.buildDefaultPrincipal(securityType.getDefaultPrincipal()));
        return security;
    }

    public static DefaultPrincipal buildDefaultPrincipal(GerDefaultPrincipalType defaultPrincipalType) {
        DefaultPrincipal defaultPrincipal = new DefaultPrincipal();
        defaultPrincipal.setPrincipal(SecurityBuilder.buildPrincipal(defaultPrincipalType.getPrincipal()));
        GerNamedUsernamePasswordCredentialType[] namedCredentials = defaultPrincipalType.getNamedUsernamePasswordCredentialArray();
        if (namedCredentials.length > 0) {
            HashSet<NamedUsernamePasswordCredential> defaultCredentialSet = new HashSet<NamedUsernamePasswordCredential>();
            for (int i = 0; i < namedCredentials.length; ++i) {
                GerNamedUsernamePasswordCredentialType namedCredentialType = namedCredentials[i];
                NamedUsernamePasswordCredential namedCredential = new NamedUsernamePasswordCredential(namedCredentialType.getUsername().trim(), namedCredentialType.getPassword().trim().toCharArray(), namedCredentialType.getName().trim());
                defaultCredentialSet.add(namedCredential);
            }
            defaultPrincipal.setNamedUserPasswordCredentials(defaultCredentialSet);
        }
        return defaultPrincipal;
    }

    public static RealmPrincipalInfo buildRealmPrincipal(GerRealmPrincipalType realmPrincipalType) {
        return new RealmPrincipalInfo(realmPrincipalType.getDomainName().trim(), realmPrincipalType.getRealmName().trim(), realmPrincipalType.getClass1().trim(), realmPrincipalType.getName().trim(), realmPrincipalType.isSetDesignatedRunAs());
    }

    public static LoginDomainPrincipalInfo buildDomainPrincipal(GerLoginDomainPrincipalType domainPrincipalType) {
        return new LoginDomainPrincipalInfo(domainPrincipalType.getDomainName().trim(), domainPrincipalType.getClass1().trim(), domainPrincipalType.getName().trim(), domainPrincipalType.isSetDesignatedRunAs());
    }

    public static PrincipalInfo buildPrincipal(GerPrincipalType principalType) {
        return new PrincipalInfo(principalType.getClass1().trim(), principalType.getName().trim(), principalType.isSetDesignatedRunAs());
    }

    public static GBeanData configureRoleMapper(Naming naming, AbstractName moduleName, SecurityConfiguration securityConfiguration) {
        AbstractName roleMapperName = naming.createChildName(moduleName, "RoleMapper", "RoleMapper");
        GBeanData roleMapperData = new GBeanData(roleMapperName, ApplicationPrincipalRoleConfigurationManager.GBEAN_INFO);
        roleMapperData.setAttribute("principalRoleMap", (Object)securityConfiguration.getPrincipalRoleMap());
        return roleMapperData;
    }

    public static GBeanData configureApplicationPolicyManager(Naming naming, AbstractName moduleName, Map contextIDToPermissionsMap, SecurityConfiguration securityConfiguration) {
        AbstractName jaccBeanName = naming.createChildName(moduleName, "JACCManager", "JACCManager");
        GBeanData jaccBeanData = new GBeanData(jaccBeanName, ApplicationPolicyConfigurationManager.GBEAN_INFO);
        jaccBeanData.setAttribute("contextIdToPermissionsMap", (Object)contextIDToPermissionsMap);
        jaccBeanData.setAttribute("roleDesignates", (Object)securityConfiguration.getRoleDesignates());
        return jaccBeanData;
    }
}

