/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.deployment;

import org.apache.geronimo.security.deploy.AutoMapAssistant;
import org.apache.geronimo.security.deploy.DefaultPrincipal;
import org.apache.geronimo.security.deploy.Principal;
import org.apache.geronimo.security.deploy.Realm;
import org.apache.geronimo.security.deploy.Role;
import org.apache.geronimo.security.deploy.Security;
import org.apache.geronimo.xbeans.geronimo.security.GerAutoMapRolesType;
import org.apache.geronimo.xbeans.geronimo.security.GerClassOverrideType;
import org.apache.geronimo.xbeans.geronimo.security.GerDefaultPrincipalType;
import org.apache.geronimo.xbeans.geronimo.security.GerPrincipalType;
import org.apache.geronimo.xbeans.geronimo.security.GerRealmType;
import org.apache.geronimo.xbeans.geronimo.security.GerRoleMappingsType;
import org.apache.geronimo.xbeans.geronimo.security.GerRoleType;
import org.apache.geronimo.xbeans.geronimo.security.GerSecurityType;

public class SecurityBuilder {
    public static Security buildSecurityConfig(GerSecurityType securityType) {
        Security security = null;
        if (securityType != null) {
            GerAutoMapRolesType autoMapRolesType;
            security = new Security();
            security.setDoAsCurrentCaller(securityType.getDoasCurrentCaller());
            security.setUseContextHandler(securityType.getUseContextHandler());
            security.setDefaultRole(securityType.getDefaultRole());
            GerDefaultPrincipalType defaultPrincipalType = securityType.getDefaultPrincipal();
            DefaultPrincipal defaultPrincipal = new DefaultPrincipal();
            defaultPrincipal.setRealmName(defaultPrincipalType.getRealmName());
            defaultPrincipal.setPrincipal(SecurityBuilder.buildPrincipal(defaultPrincipalType.getPrincipal()));
            security.setDefaultPrincipal(defaultPrincipal);
            GerRoleMappingsType roleMappingsType = securityType.getRoleMappings();
            if (roleMappingsType != null) {
                for (int i = 0; i < roleMappingsType.sizeOfRoleArray(); ++i) {
                    GerRoleType roleType = roleMappingsType.getRoleArray(i);
                    Role role = new Role();
                    role.setRoleName(roleType.getRoleName());
                    for (int j = 0; j < roleType.sizeOfRealmArray(); ++j) {
                        GerRealmType realmType = roleType.getRealmArray(j);
                        Realm realm = new Realm();
                        realm.setRealmName(realmType.getRealmName());
                        for (int k = 0; k < realmType.sizeOfPrincipalArray(); ++k) {
                            realm.getPrincipals().add(SecurityBuilder.buildPrincipal(realmType.getPrincipalArray(k)));
                        }
                        role.getRealms().add(realm);
                    }
                    security.getRoleMappings().add(role);
                }
            }
            if ((autoMapRolesType = securityType.getAutoMapRoles()) != null) {
                AutoMapAssistant assistant = new AutoMapAssistant();
                assistant.setSecurityRealm(autoMapRolesType.getSecurityRealm());
                GerClassOverrideType[] classOverrideArray = autoMapRolesType.getClassOverrideArray();
                for (int i = 0; i < classOverrideArray.length; ++i) {
                    assistant.getClassOverrides().add(classOverrideArray[i].getClass1());
                }
                security.setAssistant(assistant);
            }
        }
        return security;
    }

    private static Principal buildPrincipal(GerPrincipalType principalType) {
        Principal principal = new Principal();
        principal.setClassName(principalType.getClass1());
        principal.setPrincipalName(principalType.getName());
        principal.setDesignatedRunAs(principalType.isSetDesignatedRunAs());
        return principal;
    }
}

