/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.transport.async.nio;

import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.remoting.transport.async.nio.SelectionEventListner;

public class SelectorManager
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)SelectorManager.class);
    private static SelectorManager instance;
    private volatile boolean running;
    private Selector selector;
    private ThreadGroup threadGroup = new ThreadGroup("NIO remoting Workers");
    private int startCounter;

    protected SelectorManager() throws IOException {
        this.selector = Selector.open();
    }

    public static synchronized SelectorManager getInstance() throws IOException {
        if (instance == null) {
            instance = new SelectorManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            log.debug((Object)"Selector Work thread has started.");
            while (this.running) {
                log.trace((Object)"Waiting for selector to return");
                int count = this.selector.select(500L);
                if (count == 0) continue;
                Set<SelectionKey> keys = this.selector.selectedKeys();
                Iterator<SelectionKey> i = keys.iterator();
                while (i.hasNext()) {
                    SelectionKey key = i.next();
                    ((SelectionEventListner)key.attachment()).selectionEvent(key);
                    i.remove();
                }
            }
        }
        catch (SocketException e) {
            log.warn((Object)"SocketException occured (Connection reset by peer?).");
        }
        catch (IOException e) {
            log.warn((Object)"IOException occured.", (Throwable)e);
        }
        finally {
            log.debug((Object)"Selector Work thread has stopped.");
        }
    }

    public synchronized void start() {
        ++this.startCounter;
        if (this.startCounter == 1) {
            log.debug((Object)"Starting a Selector Work thread.");
            this.running = true;
            new Thread(this.threadGroup, this, "Selector Worker").start();
        }
    }

    public synchronized void stop() {
        --this.startCounter;
        if (this.startCounter == 0) {
            log.debug((Object)"Stopping a Selector Work thread.");
            this.running = false;
        }
    }

    public SelectionKey register(SocketChannel socketChannel, int ops, SelectionEventListner listner) throws ClosedChannelException {
        SelectionKey key = socketChannel.register(this.selector, ops, listner);
        this.selector.wakeup();
        return key;
    }

    public void setInterestOps(SelectionKey selectionKey, int ops) {
        selectionKey.interestOps(ops);
        this.selector.wakeup();
    }
}

