/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.transport.async.bio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.remoting.router.Router;
import org.apache.geronimo.remoting.transport.TransportException;
import org.apache.geronimo.remoting.transport.URISupport;
import org.apache.geronimo.remoting.transport.async.AbstractServer;
import org.apache.geronimo.remoting.transport.async.ChannelPool;
import org.apache.geronimo.remoting.transport.async.bio.BlockingChannel;

public final class BlockingServer
extends AbstractServer
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)BlockingServer.class);
    private static final int SO_TIMEOUT = 5000;
    private ServerSocketChannel serverSocketChannel;
    private URI uri;
    private URI connectURI;
    private Thread worker;
    private boolean running;
    private int compression = -1;
    private boolean enableTcpNoDelay;
    private Router nextRouter;

    public void bind(URI localURI, Router dispatcher) throws IOException, URISyntaxException {
        int serverBindPort;
        this.uri = localURI;
        this.nextRouter = dispatcher;
        String serverBindAddress = this.uri.getHost();
        String clientConnectAddress = null;
        int clientConnectPort = serverBindPort = this.uri.getPort();
        int connectBackLog = 50;
        this.enableTcpNoDelay = true;
        Properties params = URISupport.parseQueryParameters(this.uri);
        this.enableTcpNoDelay = params.getProperty("tcp.nodelay", "true").equals("true");
        connectBackLog = Integer.parseInt(params.getProperty("tcp.backlog", "50"));
        clientConnectAddress = params.getProperty("client.host");
        clientConnectPort = Integer.parseInt(params.getProperty("client.port", "0"));
        clientConnectPort = Integer.parseInt(params.getProperty("compression", "-1"));
        this.compression = Math.min(this.compression, 9);
        this.compression = Math.max(this.compression, -1);
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.socket().bind(new InetSocketAddress(InetAddress.getByName(serverBindAddress), serverBindPort), connectBackLog);
        this.serverSocketChannel.socket().setSoTimeout(5000);
        clientConnectAddress = clientConnectAddress == null || clientConnectAddress.length() == 0 ? InetAddress.getLocalHost().getHostName() : clientConnectAddress;
        clientConnectPort = clientConnectPort <= 0 ? this.serverSocketChannel.socket().getLocalPort() : clientConnectPort;
        Properties clientParms = new Properties();
        clientParms.put("tcp.nodelay", this.enableTcpNoDelay ? "true" : "false");
        clientParms.put("compression", "" + this.compression);
        this.connectURI = new URI("async", null, clientConnectAddress, clientConnectPort, "", URISupport.toQueryString(clientParms), null);
        log.info((Object)("Remoting 'async' protocol available at: " + this.serverSocketChannel.socket().getInetAddress() + ":" + this.serverSocketChannel.socket().getLocalPort()));
        log.info((Object)("Remoting 'async' protocol clients will connect to: " + this.connectURI));
    }

    public synchronized void start() throws Exception {
        if (this.running) {
            return;
        }
        this.running = true;
        this.worker = new Thread((Runnable)this, "Acceptor " + this.getClientConnectURI());
        this.worker.setDaemon(true);
        this.worker.start();
        super.start();
    }

    public void stop() throws Exception {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.worker.interrupt();
            this.worker.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.stop();
    }

    public void run() {
        block9: while (true) {
            try {
                while (this.running) {
                    SocketChannel socket;
                    block11: {
                        socket = null;
                        try {
                            socket = this.serverSocketChannel.accept();
                            if (!log.isTraceEnabled()) break block11;
                            log.trace((Object)("Accepted connection: " + socket));
                        }
                        catch (InterruptedIOException e) {
                            continue;
                        }
                    }
                    try {
                        socket.socket().setTcpNoDelay(this.enableTcpNoDelay);
                        BlockingChannel channel = new BlockingChannel();
                        channel.init(this.connectURI, socket);
                        ChannelPool pool = this.getChannelPool(channel.getRemoteURI());
                        pool.setBackConnectURI(channel.getRequestedURI());
                        pool.associate(channel);
                        continue block9;
                    }
                    catch (TransportException ie) {
                        log.debug((Object)"Client connection could not be accepted: ", (Throwable)ie);
                    }
                    catch (IOException ie) {
                        log.debug((Object)"Client connection could not be accepted: ", (Throwable)ie);
                    }
                    catch (URISyntaxException e) {
                        log.debug((Object)"Client connection could not be accepted: ", (Throwable)e);
                    }
                }
                break;
            }
            catch (SocketException e) {
                if (!this.running) break;
                log.warn((Object)"SocketException occured (Connection reset by peer?). Shutting down remoting 'async' protocol.");
                break;
            }
            catch (IOException e) {
                if (!this.running) break;
                log.warn((Object)"IOException occured. Shutting down remoting 'async' protocol.");
                break;
            }
        }
    }

    public URI getClientConnectURI() {
        return this.connectURI;
    }

    public void dispose() throws Exception {
        if (this.running) {
            this.running = false;
            this.worker.interrupt();
        }
        this.serverSocketChannel.close();
        super.dispose();
    }

    public Router getNextRouter() {
        return this.nextRouter;
    }
}

