/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.transport.async;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.geronimo.core.service.Interceptor;
import org.apache.geronimo.core.service.Invocation;
import org.apache.geronimo.core.service.InvocationResult;
import org.apache.geronimo.core.service.SimpleInvocationResult;
import org.apache.geronimo.proxy.ProxyInvocation;
import org.apache.geronimo.remoting.transport.async.RemoteRef;

public class IdentityInterceptor
implements Interceptor,
Serializable {
    private static final Method EQUALS_METHOD;
    private static final Method HASHCODE_METHOD;
    private RemoteRef ref;
    private Interceptor next;

    public IdentityInterceptor(Interceptor next, RemoteRef ref) {
        this.next = next;
        this.ref = ref;
    }

    public InvocationResult invoke(Invocation invocation) throws Throwable {
        Method method = ProxyInvocation.getMethod((Invocation)invocation);
        if (method.equals(EQUALS_METHOD)) {
            Object[] args;
            Object proxy = ProxyInvocation.getProxy((Invocation)invocation);
            return new SimpleInvocationResult(true, (Object)(proxy == (args = ProxyInvocation.getArguments((Invocation)invocation))[0] ? Boolean.TRUE : Boolean.FALSE));
        }
        if (method.equals(HASHCODE_METHOD)) {
            return new SimpleInvocationResult(true, (Object)new Integer(this.ref.hashCode()));
        }
        return this.next.invoke(invocation);
    }

    static {
        try {
            EQUALS_METHOD = Object.class.getMethod("equals", Object.class);
            HASHCODE_METHOD = Object.class.getMethod("hashCode", null);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

