/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.transport.async;

import EDU.oswego.cs.dl.util.concurrent.Slot;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Correlator {
    private final ReferenceQueue queue = new ReferenceQueue();
    Log log = LogFactory.getLog((Class)Correlator.class);
    private Map slots = new HashMap(100);
    private int nextFutureResultID = 0;
    private Object nextFutureResultIDLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextFutureResultID() {
        Object object = this.nextFutureResultIDLock;
        synchronized (object) {
            return this.nextFutureResultID++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResult getNextFutureResult() {
        HashKey key = new HashKey(this.getNextFutureResultID());
        FutureResult s = new FutureResult(key);
        Map map = this.slots;
        synchronized (map) {
            this.slots.put(key, new SlotReference(key, (Object)s));
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Created Request: " + key.value));
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchResponse(int id, Object data) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Received resposne for request: " + id));
        }
        FutureResult s = null;
        Map map = this.slots;
        synchronized (map) {
            this.processQueue();
            SlotReference ref = (SlotReference)this.slots.get(new HashKey(id));
            if (ref != null) {
                s = (FutureResult)((Object)ref.get());
            }
        }
        if (s != null) {
            try {
                s.put(data);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            this.log.trace((Object)"The request may have timed out.  Request slot was not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueue() {
        SlotReference slotRef;
        while ((slotRef = (SlotReference)this.queue.poll()) != null) {
            Map map = this.slots;
            synchronized (map) {
                this.slots.remove(slotRef.key);
            }
        }
    }

    private class SlotReference
    extends WeakReference {
        private final Object key;

        public SlotReference(Object key, Object lock) {
            super(lock, Correlator.this.queue);
            this.key = key;
        }
    }

    private static class HashKey {
        final int value;
        final int hashCode;

        public HashKey(int value) {
            this.value = value;
            long rc = value;
            if (value % 2 == 1) {
                rc *= -1L;
            }
            this.hashCode = (int)((rc *= 306783378L) % Integer.MAX_VALUE);
        }

        public boolean equals(Object obj) {
            return ((HashKey)obj).value == this.value;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    public static class FutureResult
    extends Slot {
        private final HashKey key;

        FutureResult(HashKey key) {
            this.key = key;
        }

        public int getID() {
            return this.key.value;
        }
    }
}

