/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.remoting.transport.async;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StreamCorruptedException;
import org.apache.geronimo.remoting.transport.BytesMsg;
import org.apache.geronimo.remoting.transport.Msg;
import org.apache.geronimo.remoting.transport.async.Registry;

public class AsyncMsg
extends BytesMsg {
    public static final byte DATAGRAM_TYPE = 0;
    public static final byte REQUEST_TYPE = 1;
    public static final byte RESPONE_TYPE = 2;
    byte type = 1;
    int requestId;
    String to;

    public AsyncMsg() {
        super(Registry.transportContext);
    }

    public Msg createMsg() {
        return new AsyncMsg();
    }

    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(this.type);
        switch (this.type) {
            case 0: {
                out.writeUTF(this.to);
                break;
            }
            case 1: {
                out.writeInt(this.requestId);
                out.writeUTF(this.to);
                break;
            }
            case 2: {
                out.writeInt(this.requestId);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknow type: " + this.type);
            }
        }
    }

    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.type = in.readByte();
        this.requestId = 0;
        switch (this.type) {
            case 0: {
                this.to = in.readUTF();
                break;
            }
            case 1: {
                this.requestId = in.readInt();
                this.to = in.readUTF();
                break;
            }
            case 2: {
                this.requestId = in.readInt();
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknow type: " + this.type);
            }
        }
    }
}

